/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.redisson;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.redisson.RedissonNamedLockFactorySupport;
import org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.redisson.api.RSemaphore;

@Singleton
@Named(value="semaphore-redisson")
public class RedissonSemaphoreNamedLockFactory
extends RedissonNamedLockFactorySupport {
    public static final String NAME = "semaphore-redisson";
    private static final String TYPED_NAME_PREFIX = "maven:resolver:semaphore-redisson:";
    private final ConcurrentMap<NamedLockKey, RSemaphore> semaphores = new ConcurrentHashMap<NamedLockKey, RSemaphore>();

    protected AdaptedSemaphoreNamedLock createLock(NamedLockKey key) {
        RSemaphore semaphore = this.semaphores.computeIfAbsent(key, k -> {
            RSemaphore result = this.redissonClient.getSemaphore(TYPED_NAME_PREFIX + k.name());
            result.trySetPermits(Integer.MAX_VALUE);
            return result;
        });
        return new AdaptedSemaphoreNamedLock(key, (NamedLockFactorySupport)this, (AdaptedSemaphoreNamedLock.AdaptedSemaphore)new RedissonSemaphore(semaphore));
    }

    protected void destroyLock(NamedLock namedLock) {
        NamedLockKey key;
        RSemaphore semaphore;
        if (namedLock instanceof AdaptedSemaphoreNamedLock && (semaphore = (RSemaphore)this.semaphores.remove(key = namedLock.key())) == null) {
            throw new IllegalStateException("Semaphore expected, but does not exist: " + key);
        }
    }

    private static final class RedissonSemaphore
    implements AdaptedSemaphoreNamedLock.AdaptedSemaphore {
        private final RSemaphore semaphore;

        private RedissonSemaphore(RSemaphore semaphore) {
            this.semaphore = semaphore;
        }

        public boolean tryAcquire(int perms, long time, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(perms, time, unit);
        }

        public void release(int perms) {
            this.semaphore.release(perms);
        }
    }
}

