/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.redisson;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public abstract class RedissonNamedLockFactorySupport
extends NamedLockFactorySupport {
    protected static final String NAME_PREFIX = "maven:resolver:";
    private static final String DEFAULT_CONFIG_FILE_NAME = "maven-resolver-redisson.yaml";
    private static final String DEFAULT_REDIS_ADDRESS = "redis://localhost:6379";
    private static final String DEFAULT_CLIENT_NAME = "maven-resolver";
    private static final String CONFIG_PROP_CONFIG_FILE = "aether.syncContext.named.redisson.configFile";
    protected final RedissonClient redissonClient = this.createRedissonClient();

    public void shutdown() {
        this.logger.trace("Shutting down Redisson client with id '{}'", (Object)this.redissonClient.getId());
        this.redissonClient.shutdown();
    }

    private RedissonClient createRedissonClient() {
        Config config;
        block11: {
            String mavenConf;
            Path configFilePath = null;
            String configFile = System.getProperty(CONFIG_PROP_CONFIG_FILE);
            if (configFile != null && !configFile.isEmpty() && Files.notExists(configFilePath = Paths.get(configFile, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException("The specified Redisson config file does not exist: " + configFilePath);
            }
            if (configFilePath == null && (mavenConf = System.getProperty("maven.conf")) != null && !mavenConf.isEmpty() && Files.notExists(configFilePath = Paths.get(mavenConf, DEFAULT_CONFIG_FILE_NAME), new LinkOption[0])) {
                configFilePath = null;
            }
            if (configFilePath != null) {
                this.logger.trace("Reading Redisson config file from '{}'", (Object)configFilePath);
                try (InputStream is = Files.newInputStream(configFilePath, new OpenOption[0]);){
                    config = Config.fromYAML((InputStream)is);
                    break block11;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read Redisson config file: " + configFilePath, e);
                }
            }
            config = new Config();
            config.useSingleServer().setAddress(DEFAULT_REDIS_ADDRESS).setClientName(DEFAULT_CLIENT_NAME);
        }
        RedissonClient redissonClient = Redisson.create((Config)config);
        this.logger.trace("Created Redisson client with id '{}'", (Object)redissonClient.getId());
        return redissonClient;
    }
}

