/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.redisson;

import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.named.redisson.RedissonNamedLockFactorySupport;
import org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.eclipse.aether.named.support.NamedLockSupport;
import org.redisson.api.RSemaphore;

@Singleton
@Named(value="semaphore-redisson")
public class RedissonSemaphoreNamedLockFactory
extends RedissonNamedLockFactorySupport {
    public static final String NAME = "semaphore-redisson";

    protected NamedLockSupport createLock(String name) {
        return new AdaptedSemaphoreNamedLock(name, (NamedLockFactorySupport)this, (AdaptedSemaphoreNamedLock.AdaptedSemaphore)new RedissonSemaphore(this.redissonClient.getSemaphore("maven:resolver:" + name)));
    }

    private static final class RedissonSemaphore
    implements AdaptedSemaphoreNamedLock.AdaptedSemaphore {
        private final RSemaphore semaphore;

        private RedissonSemaphore(RSemaphore semaphore) {
            semaphore.trySetPermits(Integer.MAX_VALUE);
            this.semaphore = semaphore;
        }

        public boolean tryAcquire(int perms, long time, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(perms, time, unit);
        }

        public void release(int perms) {
            this.semaphore.release(perms);
        }
    }
}

