/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.scope;

import java.util.Objects;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

public final class OptionalDependencySelector
implements DependencySelector {
    private final int seed;
    private final int depth;
    private final int applyFrom;

    public static OptionalDependencySelector fromRoot() {
        return OptionalDependencySelector.from(1);
    }

    public static OptionalDependencySelector fromDirect() {
        return OptionalDependencySelector.from(2);
    }

    public static OptionalDependencySelector from(int applyFrom) {
        if (applyFrom < 1) {
            throw new IllegalArgumentException("applyFrom must be non-zero and positive");
        }
        return new OptionalDependencySelector(Objects.hash(applyFrom), 0, applyFrom);
    }

    private OptionalDependencySelector(int seed, int depth, int applyFrom) {
        this.seed = seed;
        this.depth = depth;
        this.applyFrom = applyFrom;
    }

    public boolean selectDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        return this.depth < this.applyFrom || !dependency.isOptional();
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        return new OptionalDependencySelector(this.seed, this.depth + 1, this.applyFrom);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        OptionalDependencySelector that = (OptionalDependencySelector)obj;
        return this.seed == that.seed && this.depth == that.depth && this.applyFrom == that.applyFrom;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.seed;
        hash = hash * 31 + this.depth;
        hash = hash * 31 + this.applyFrom;
        return hash;
    }

    public String toString() {
        return String.format("%s(applied: %s)", this.getClass().getSimpleName(), this.depth >= this.applyFrom);
    }
}

