/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.spi.locking.LockingInhibitor;

public class InhibitingNameMapper
implements NameMapper {
    private final NameMapper delegate;
    private final List<LockingInhibitor> lockingInhibitors;

    public InhibitingNameMapper(NameMapper delegate, List<LockingInhibitor> lockingInhibitors) {
        this.delegate = Objects.requireNonNull(delegate);
        this.lockingInhibitors = Objects.requireNonNull(lockingInhibitors);
    }

    @Override
    public boolean isFileSystemFriendly() {
        return this.delegate.isFileSystemFriendly();
    }

    @Override
    public Collection<NamedLockKey> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        if (artifacts != null) {
            artifacts = artifacts.stream().filter(a -> this.lockingInhibitors.stream().noneMatch(i -> i.preventArtifactLocking(a))).collect(Collectors.toList());
        }
        if (metadatas != null) {
            metadatas = metadatas.stream().filter(m -> this.lockingInhibitors.stream().noneMatch(i -> i.preventMetadataLocking(m))).collect(Collectors.toList());
        }
        return this.delegate.nameLocks(session, artifacts, metadatas);
    }
}

