/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter.ruletree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.internal.impl.filter.ruletree.Node;

public class GroupTree
extends Node<GroupTree> {
    private static final String ROOT = "*";
    private static final String MOD_EXCLUSION = "!";
    private static final String MOD_STOP = "=";
    private boolean stop;
    private Boolean accept;

    public static GroupTree create(String name) {
        GroupTree result = new GroupTree(name);
        result.accept = false;
        return result;
    }

    private static List<String> elementsOfGroup(String groupId) {
        return Arrays.stream(groupId.split("\\.")).filter(e -> !e.isEmpty()).collect(Collectors.toList());
    }

    private GroupTree(String name) {
        super(name);
    }

    public int loadNodes(Stream<String> linesStream) {
        AtomicInteger counter = new AtomicInteger(0);
        linesStream.forEach(line -> {
            if (this.loadNode((String)line)) {
                counter.incrementAndGet();
            }
        });
        return counter.get();
    }

    public boolean loadNode(String line) {
        if (!line.startsWith("#") && !line.trim().isEmpty()) {
            GroupTree currentNode = this;
            boolean accept = true;
            if (line.startsWith(MOD_EXCLUSION)) {
                accept = false;
                line = line.substring(MOD_EXCLUSION.length());
            }
            boolean stop = false;
            if (line.startsWith(MOD_STOP)) {
                stop = true;
                line = line.substring(MOD_STOP.length());
            }
            if (ROOT.equals(line)) {
                this.accept = accept;
                return true;
            }
            List<String> groupElements = GroupTree.elementsOfGroup(line);
            for (String groupElement : groupElements.subList(0, groupElements.size() - 1)) {
                currentNode = currentNode.siblings.computeIfAbsent(groupElement, GroupTree::new);
            }
            String lastElement = groupElements.get(groupElements.size() - 1);
            currentNode = currentNode.siblings.computeIfAbsent(lastElement, GroupTree::new);
            currentNode.stop = stop;
            currentNode.accept = accept;
            return true;
        }
        return false;
    }

    public boolean acceptedGroupId(String groupId) {
        ArrayList<String> current = new ArrayList<String>();
        List<String> groupElements = GroupTree.elementsOfGroup(groupId);
        Boolean accepted = null;
        GroupTree currentNode = this;
        for (String groupElement : groupElements) {
            current.add(groupElement);
            currentNode = (GroupTree)currentNode.siblings.get(groupElement);
            if (currentNode == null) break;
            if (currentNode.stop && groupElements.equals(current)) {
                accepted = currentNode.accept;
                break;
            }
            if (currentNode.stop || currentNode.accept == null) continue;
            accepted = currentNode.accept;
        }
        return accepted != null ? accepted : this.accept;
    }

    @Override
    public String toString() {
        return (this.accept != null ? (this.accept.booleanValue() ? "+" : "-") : "?") + (this.stop ? MOD_STOP : "") + this.name;
    }

    @Override
    public void dump(String prefix) {
        System.out.println(prefix + this);
        for (GroupTree node : this.siblings.values()) {
            node.dump(prefix + "  ");
        }
    }
}

