/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryKeyFunction;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.remoterepo.RepositoryKeyFunctionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultRemoteRepositoryManager
implements RemoteRepositoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRemoteRepositoryManager.class);
    private final UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private final ChecksumPolicyProvider checksumPolicyProvider;
    private final RepositoryKeyFunctionFactory repositoryKeyFunctionFactory;

    @Inject
    public DefaultRemoteRepositoryManager(UpdatePolicyAnalyzer updatePolicyAnalyzer, ChecksumPolicyProvider checksumPolicyProvider, RepositoryKeyFunctionFactory repositoryKeyFunctionFactory) {
        this.updatePolicyAnalyzer = Objects.requireNonNull(updatePolicyAnalyzer, "update policy analyzer cannot be null");
        this.checksumPolicyProvider = Objects.requireNonNull(checksumPolicyProvider, "checksum policy provider cannot be null");
        this.repositoryKeyFunctionFactory = Objects.requireNonNull(repositoryKeyFunctionFactory, "repository key function factory cannot be null");
    }

    @Override
    public List<RemoteRepository> aggregateRepositories(RepositorySystemSession session, List<RemoteRepository> dominantRepositories, List<RemoteRepository> recessiveRepositories, boolean recessiveIsRaw) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(dominantRepositories, "dominantRepositories cannot be null");
        Objects.requireNonNull(recessiveRepositories, "recessiveRepositories cannot be null");
        if (recessiveRepositories.isEmpty()) {
            return dominantRepositories;
        }
        RepositoryKeyFunction repositoryKeyFunction = this.repositoryKeyFunctionFactory.systemRepositoryKeyFunction(session);
        MirrorSelector mirrorSelector = session.getMirrorSelector();
        AuthenticationSelector authSelector = session.getAuthenticationSelector();
        ProxySelector proxySelector = session.getProxySelector();
        ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>(dominantRepositories);
        Iterator<RemoteRepository> iterator = recessiveRepositories.iterator();
        block0: while (iterator.hasNext()) {
            RemoteRepository mirrorRepository;
            RemoteRepository recessiveRepository;
            RemoteRepository repository = recessiveRepository = iterator.next();
            if (recessiveIsRaw && (mirrorRepository = mirrorSelector.getMirror(recessiveRepository)) != null) {
                this.logMirror(session, recessiveRepository, mirrorRepository);
                repository = mirrorRepository;
            }
            String key = repositoryKeyFunction.apply(repository, null);
            ListIterator<RemoteRepository> it = result.listIterator();
            while (it.hasNext()) {
                RemoteRepository mergedRepository;
                RemoteRepository dominantRepository = (RemoteRepository)it.next();
                if (!key.equals(repositoryKeyFunction.apply(dominantRepository, null))) continue;
                if (dominantRepository.getMirroredRepositories().isEmpty() || repository.getMirroredRepositories().isEmpty() || (mergedRepository = this.mergeMirrors(session, repositoryKeyFunction, dominantRepository, repository)) == dominantRepository) continue block0;
                it.set(mergedRepository);
                continue block0;
            }
            if (recessiveIsRaw) {
                Proxy proxy;
                RemoteRepository.Builder builder = null;
                Authentication auth = authSelector.getAuthentication(repository);
                if (auth != null) {
                    builder = new RemoteRepository.Builder(repository);
                    builder.setAuthentication(auth);
                }
                if ((proxy = proxySelector.getProxy(repository)) != null) {
                    if (builder == null) {
                        builder = new RemoteRepository.Builder(repository);
                    }
                    builder.setProxy(proxy);
                }
                if (builder != null) {
                    repository = builder.build();
                }
            }
            result.add(repository);
        }
        return result.stream().map(r -> new RemoteRepository.Builder(r).setIntent(RemoteRepository.Intent.RESOLUTION).build()).collect(Collectors.toList());
    }

    private void logMirror(RepositorySystemSession session, RemoteRepository original, RemoteRepository mirror) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        RepositoryCache cache = session.getCache();
        if (cache != null) {
            LoggedMirror key = new LoggedMirror(original, mirror);
            if (cache.get(session, (Object)key) != null) {
                return;
            }
            cache.put(session, (Object)key, (Object)Boolean.TRUE);
        }
        LOGGER.debug("Using mirror {} ({}) for {} ({}).", new Object[]{mirror.getId(), mirror.getUrl(), original.getId(), original.getUrl()});
    }

    private RemoteRepository mergeMirrors(RepositorySystemSession session, RepositoryKeyFunction repositoryKeyFunction, RemoteRepository dominant, RemoteRepository recessive) {
        RemoteRepository.Builder merged = null;
        RepositoryPolicy releases = null;
        RepositoryPolicy snapshots = null;
        block0: for (RemoteRepository rec : recessive.getMirroredRepositories()) {
            String recKey = repositoryKeyFunction.apply(rec, null);
            for (RemoteRepository dom : dominant.getMirroredRepositories()) {
                if (!recKey.equals(repositoryKeyFunction.apply(dom, null))) continue;
                continue block0;
            }
            if (merged == null) {
                merged = new RemoteRepository.Builder(dominant);
                releases = dominant.getPolicy(false);
                snapshots = dominant.getPolicy(true);
            }
            releases = this.merge(session, releases, rec.getPolicy(false), false);
            snapshots = this.merge(session, snapshots, rec.getPolicy(true), false);
            merged.addMirroredRepository(rec);
        }
        if (merged == null) {
            return dominant;
        }
        return merged.setReleasePolicy(releases).setSnapshotPolicy(snapshots).build();
    }

    @Override
    public RepositoryPolicy getPolicy(RepositorySystemSession session, RemoteRepository repository, boolean releases, boolean snapshots) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        RepositoryPolicy policy1 = releases ? repository.getPolicy(false) : null;
        RepositoryPolicy policy2 = snapshots ? repository.getPolicy(true) : null;
        return this.merge(session, policy1, policy2, true);
    }

    private RepositoryPolicy merge(RepositorySystemSession session, RepositoryPolicy policy1, RepositoryPolicy policy2, boolean globalPolicy) {
        RepositoryPolicy policy;
        if (policy2 == null) {
            policy = globalPolicy ? this.merge(policy1, session.getArtifactUpdatePolicy(), session.getMetadataUpdatePolicy(), session.getChecksumPolicy()) : policy1;
        } else if (policy1 == null) {
            policy = globalPolicy ? this.merge(policy2, session.getArtifactUpdatePolicy(), session.getMetadataUpdatePolicy(), session.getChecksumPolicy()) : policy2;
        } else if (!policy2.isEnabled()) {
            policy = globalPolicy ? this.merge(policy1, session.getArtifactUpdatePolicy(), session.getMetadataUpdatePolicy(), session.getChecksumPolicy()) : policy1;
        } else if (!policy1.isEnabled()) {
            policy = globalPolicy ? this.merge(policy2, session.getArtifactUpdatePolicy(), session.getMetadataUpdatePolicy(), session.getChecksumPolicy()) : policy2;
        } else {
            String checksums = session.getChecksumPolicy();
            if (!globalPolicy || checksums == null || checksums.isEmpty()) {
                checksums = this.checksumPolicyProvider.getEffectiveChecksumPolicy(session, policy1.getChecksumPolicy(), policy2.getChecksumPolicy());
            }
            String artifactUpdates = session.getArtifactUpdatePolicy();
            if (!globalPolicy || artifactUpdates == null || artifactUpdates.isEmpty()) {
                artifactUpdates = this.updatePolicyAnalyzer.getEffectiveUpdatePolicy(session, policy1.getArtifactUpdatePolicy(), policy2.getArtifactUpdatePolicy());
            }
            String metadataUpdates = session.getMetadataUpdatePolicy();
            if (!globalPolicy || metadataUpdates == null || metadataUpdates.isEmpty()) {
                metadataUpdates = this.updatePolicyAnalyzer.getEffectiveUpdatePolicy(session, policy1.getMetadataUpdatePolicy(), policy2.getMetadataUpdatePolicy());
            }
            policy = new RepositoryPolicy(true, artifactUpdates, metadataUpdates, checksums);
        }
        return policy;
    }

    private RepositoryPolicy merge(RepositoryPolicy policy, String artifactUpdates, String metadataUpdates, String checksums) {
        if (policy != null) {
            if (artifactUpdates == null || artifactUpdates.isEmpty()) {
                artifactUpdates = policy.getArtifactUpdatePolicy();
            }
            if (metadataUpdates == null || metadataUpdates.isEmpty()) {
                metadataUpdates = policy.getMetadataUpdatePolicy();
            }
            if (checksums == null || checksums.isEmpty()) {
                checksums = policy.getChecksumPolicy();
            }
            if (!(policy.getArtifactUpdatePolicy().equals(artifactUpdates) && policy.getMetadataUpdatePolicy().equals(metadataUpdates) && policy.getChecksumPolicy().equals(checksums))) {
                policy = new RepositoryPolicy(policy.isEnabled(), artifactUpdates, metadataUpdates, checksums);
            }
        }
        return policy;
    }

    private static final class LoggedMirror {
        private final Object[] keys;

        LoggedMirror(RemoteRepository original, RemoteRepository mirror) {
            this.keys = new Object[]{mirror.getId(), mirror.getUrl(), original.getId(), original.getUrl()};
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LoggedMirror)) {
                return false;
            }
            LoggedMirror that = (LoggedMirror)obj;
            return Arrays.equals(this.keys, that.keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }
    }
}

