/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.artifact.ArtifactPredicate;
import org.eclipse.aether.spi.artifact.ArtifactPredicateFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    public static final String NAME = "maven2";
    private static final String CONFIG_PROPS_PREFIX = "aether.layout.maven2.";
    public static final String CONFIG_PROP_CHECKSUMS_ALGORITHMS = "aether.layout.maven2.checksumAlgorithms";
    public static final String DEFAULT_CHECKSUMS_ALGORITHMS = "SHA-1,MD5";
    private float priority;
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;
    private final ArtifactPredicateFactory artifactPredicateFactory;

    public float getPriority() {
        return this.priority;
    }

    @Inject
    public Maven2RepositoryLayoutFactory(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector, ArtifactPredicateFactory artifactPredicateFactory) {
        this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector);
        this.artifactPredicateFactory = Objects.requireNonNull(artifactPredicateFactory);
    }

    public Maven2RepositoryLayoutFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryLayout newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        List checksumsAlgorithms = this.checksumAlgorithmFactorySelector.selectList((Collection)ConfigUtils.parseCommaSeparatedUniqueNames((String)ConfigUtils.getString((RepositorySystemSession)session, (String)DEFAULT_CHECKSUMS_ALGORITHMS, (String[])new String[]{"aether.layout.maven2.checksumAlgorithms." + repository.getId(), CONFIG_PROP_CHECKSUMS_ALGORITHMS, "aether.checksums.algorithms", "aether.checksums.algorithms." + repository.getId()})));
        return new Maven2RepositoryLayout(checksumsAlgorithms, this.artifactPredicateFactory.newInstance(session));
    }

    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        private final List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms;
        private final ArtifactPredicate artifactPredicate;

        private Maven2RepositoryLayout(List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms, ArtifactPredicate artifactPredicate) {
            this.configuredChecksumAlgorithms = Collections.unmodifiableList(configuredChecksumAlgorithms);
            this.artifactPredicate = Objects.requireNonNull(artifactPredicate);
        }

        private URI toUri(String path) {
            try {
                return new URI(null, null, path, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
            return this.configuredChecksumAlgorithms;
        }

        public boolean hasChecksums(Artifact artifact) {
            return !this.artifactPredicate.isWithoutChecksum(artifact);
        }

        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            path.append(artifact.getGroupId().replace('.', '/')).append('/');
            path.append(artifact.getArtifactId()).append('/');
            path.append(artifact.getBaseVersion()).append('/');
            path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (!artifact.getClassifier().isEmpty()) {
                path.append('-').append(artifact.getClassifier());
            }
            if (!artifact.getExtension().isEmpty()) {
                path.append('.').append(artifact.getExtension());
            }
            return this.toUri(path.toString());
        }

        public URI getLocation(Metadata metadata, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            if (!metadata.getGroupId().isEmpty()) {
                path.append(metadata.getGroupId().replace('.', '/')).append('/');
                if (!metadata.getArtifactId().isEmpty()) {
                    path.append(metadata.getArtifactId()).append('/');
                    if (!metadata.getVersion().isEmpty()) {
                        path.append(metadata.getVersion()).append('/');
                    }
                }
            }
            path.append(metadata.getType());
            return this.toUri(path.toString());
        }

        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Artifact artifact, boolean upload, URI location) {
            if (this.artifactPredicate.isWithoutChecksum(artifact) || this.artifactPredicate.isChecksum(artifact)) {
                return Collections.emptyList();
            }
            return this.getChecksumLocations(location);
        }

        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Metadata metadata, boolean upload, URI location) {
            return this.getChecksumLocations(location);
        }

        private List<RepositoryLayout.ChecksumLocation> getChecksumLocations(URI location) {
            ArrayList<RepositoryLayout.ChecksumLocation> checksumLocations = new ArrayList<RepositoryLayout.ChecksumLocation>(this.configuredChecksumAlgorithms.size());
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : this.configuredChecksumAlgorithms) {
                checksumLocations.add(RepositoryLayout.ChecksumLocation.forLocation((URI)location, (ChecksumAlgorithmFactory)checksumAlgorithmFactory));
            }
            return checksumLocations;
        }
    }
}

