/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.scope;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.scope.BuildPath;
import org.eclipse.aether.impl.scope.BuildScope;
import org.eclipse.aether.impl.scope.BuildScopeQuery;
import org.eclipse.aether.impl.scope.BuildScopeSource;
import org.eclipse.aether.impl.scope.InternalScopeManager;
import org.eclipse.aether.impl.scope.ProjectPath;
import org.eclipse.aether.impl.scope.ScopeManagerConfiguration;
import org.eclipse.aether.internal.impl.scope.ManagedDependencyContextRefiner;
import org.eclipse.aether.internal.impl.scope.ManagedScopeDeriver;
import org.eclipse.aether.internal.impl.scope.ManagedScopeSelector;
import org.eclipse.aether.internal.impl.scope.OptionalDependencySelector;
import org.eclipse.aether.internal.impl.scope.ScopeDependencySelector;
import org.eclipse.aether.scope.DependencyScope;
import org.eclipse.aether.scope.ResolutionScope;
import org.eclipse.aether.scope.SystemDependencyScope;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.visitor.CloningDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;

public final class ScopeManagerImpl
implements InternalScopeManager {
    private final String id;
    private final boolean strictDependencyScopes;
    private final boolean strictResolutionScopes;
    private final BuildScopeSource buildScopeSource;
    private final AtomicReference<SystemDependencyScopeImpl> systemDependencyScope;
    private final Map<String, DependencyScopeImpl> dependencyScopes;
    private final Map<String, ResolutionScopeImpl> resolutionScopes;

    public ScopeManagerImpl(ScopeManagerConfiguration configuration) {
        this.id = configuration.getId();
        this.strictDependencyScopes = configuration.isStrictDependencyScopes();
        this.strictResolutionScopes = configuration.isStrictResolutionScopes();
        this.buildScopeSource = configuration.getBuildScopeSource();
        this.systemDependencyScope = new AtomicReference<Object>(null);
        this.dependencyScopes = Collections.unmodifiableMap(this.buildDependencyScopes(configuration));
        this.resolutionScopes = Collections.unmodifiableMap(this.buildResolutionScopes(configuration));
    }

    private Map<String, DependencyScopeImpl> buildDependencyScopes(ScopeManagerConfiguration configuration) {
        Collection<DependencyScope> dependencyScopes = configuration.buildDependencyScopes(this);
        HashMap<String, DependencyScopeImpl> result = new HashMap<String, DependencyScopeImpl>(dependencyScopes.size());
        dependencyScopes.forEach(d -> result.put(d.getId(), (DependencyScopeImpl)d));
        return result;
    }

    private Map<String, ResolutionScopeImpl> buildResolutionScopes(ScopeManagerConfiguration configuration) {
        Collection<ResolutionScope> resolutionScopes = configuration.buildResolutionScopes(this);
        HashMap<String, ResolutionScopeImpl> result = new HashMap<String, ResolutionScopeImpl>(resolutionScopes.size());
        resolutionScopes.forEach(r -> result.put(r.getId(), (ResolutionScopeImpl)r));
        return result;
    }

    public String getId() {
        return this.id;
    }

    public Optional<SystemDependencyScope> getSystemDependencyScope() {
        return Optional.ofNullable((SystemDependencyScope)this.systemDependencyScope.get());
    }

    public Optional<DependencyScope> getDependencyScope(String id) {
        DependencyScope dependencyScope = this.dependencyScopes.get(id);
        if (this.strictDependencyScopes && dependencyScope == null) {
            throw new IllegalArgumentException("unknown dependency scope");
        }
        return Optional.ofNullable(dependencyScope);
    }

    public Collection<DependencyScope> getDependencyScopeUniverse() {
        return new HashSet<DependencyScope>(this.dependencyScopes.values());
    }

    public Optional<ResolutionScope> getResolutionScope(String id) {
        ResolutionScope resolutionScope = this.resolutionScopes.get(id);
        if (this.strictResolutionScopes && resolutionScope == null) {
            throw new IllegalArgumentException("unknown resolution scope");
        }
        return Optional.ofNullable(resolutionScope);
    }

    public Collection<ResolutionScope> getResolutionScopeUniverse() {
        return new HashSet<ResolutionScope>(this.resolutionScopes.values());
    }

    @Override
    public int getDependencyScopeWidth(DependencyScope dependencyScope) {
        return this.translate(dependencyScope).getWidth();
    }

    @Override
    public Optional<BuildScope> getDependencyScopeMainProjectBuildScope(DependencyScope dependencyScope) {
        return Optional.ofNullable(this.translate(dependencyScope).getMainBuildScope());
    }

    @Override
    public DependencySelector getDependencySelector(ResolutionScope resolutionScope) {
        ResolutionScopeImpl rs = this.translate(resolutionScope);
        Set<String> directlyExcludedLabels = this.getDirectlyExcludedLabels(rs);
        Set<String> transitivelyExcludedLabels = this.getTransitivelyExcludedLabels(rs);
        return new AndDependencySelector(new DependencySelector[]{rs.getMode() == InternalScopeManager.Mode.ELIMINATE ? ScopeDependencySelector.fromTo(2, 2, null, directlyExcludedLabels) : ScopeDependencySelector.fromTo(1, 2, null, directlyExcludedLabels), ScopeDependencySelector.from(2, null, transitivelyExcludedLabels), OptionalDependencySelector.fromDirect(), new ExclusionDependencySelector()});
    }

    @Override
    public DependencyGraphTransformer getDependencyGraphTransformer(ResolutionScope resolutionScope) {
        return new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new ManagedScopeSelector(this), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new ManagedScopeDeriver(this)), new ManagedDependencyContextRefiner(this)});
    }

    @Override
    public CollectResult postProcess(ResolutionScope resolutionScope, CollectResult collectResult) {
        ResolutionScopeImpl rs = this.translate(resolutionScope);
        if (rs.getMode() == InternalScopeManager.Mode.ELIMINATE) {
            CloningDependencyVisitor cloning = new CloningDependencyVisitor();
            FilteringDependencyVisitor filter = new FilteringDependencyVisitor((DependencyVisitor)cloning, (DependencyFilter)new ScopeDependencyFilter(null, this.getDirectlyExcludedLabels(rs)));
            collectResult.getRoot().accept((DependencyVisitor)filter);
            collectResult.setRoot(cloning.getRootNode());
        }
        return collectResult;
    }

    @Override
    public DependencyFilter getDependencyFilter(ResolutionScope resolutionScope) {
        return new ScopeDependencyFilter(null, this.getDirectlyExcludedLabels(this.translate(resolutionScope)));
    }

    @Override
    public DependencyScope createDependencyScope(String id, boolean transitive, Collection<BuildScopeQuery> presence) {
        return new DependencyScopeImpl(id, transitive, presence);
    }

    @Override
    public SystemDependencyScope createSystemDependencyScope(String id, boolean transitive, Collection<BuildScopeQuery> presence, String systemPathProperty) {
        SystemDependencyScopeImpl system = new SystemDependencyScopeImpl(id, transitive, presence, systemPathProperty);
        if (this.systemDependencyScope.compareAndSet(null, system)) {
            return system;
        }
        throw new IllegalStateException("system dependency scope already created");
    }

    @Override
    public ResolutionScope createResolutionScope(String id, InternalScopeManager.Mode mode, Collection<BuildScopeQuery> wantedPresence, Collection<DependencyScope> explicitlyIncluded, Collection<DependencyScope> transitivelyExcluded) {
        return new ResolutionScopeImpl(id, mode, wantedPresence, explicitlyIncluded, transitivelyExcluded);
    }

    private Set<DependencyScope> collectScopes(Collection<BuildScopeQuery> wantedPresence) {
        HashSet<DependencyScope> result = new HashSet<DependencyScope>();
        for (BuildScope buildScope : this.buildScopeSource.query(wantedPresence)) {
            this.dependencyScopes.values().stream().filter(s -> this.buildScopeSource.query(s.getPresence()).contains(buildScope)).filter(s -> this.systemDependencyScope.get() == null || !this.systemDependencyScope.get().is(((DependencyScopeImpl)s).id)).forEach(result::add);
        }
        return result;
    }

    private int calculateDependencyScopeWidth(DependencyScopeImpl dependencyScope) {
        int result = 0;
        if (dependencyScope.isTransitive()) {
            result += 1000;
        }
        for (BuildScope buildScope : this.buildScopeSource.query(dependencyScope.getPresence())) {
            result += 1000 / buildScope.getProjectPaths().stream().map(ProjectPath::order).reduce(0, Integer::sum);
        }
        return result;
    }

    private BuildScope calculateMainProjectBuildScope(DependencyScopeImpl dependencyScope) {
        for (ProjectPath projectPath : this.buildScopeSource.allProjectPaths().stream().sorted(Comparator.comparing(ProjectPath::order)).collect(Collectors.toList())) {
            for (BuildPath buildPath : this.buildScopeSource.allBuildPaths().stream().sorted(Comparator.comparing(BuildPath::order)).collect(Collectors.toList())) {
                for (BuildScope buildScope : this.buildScopeSource.query(dependencyScope.getPresence())) {
                    if (!buildScope.getProjectPaths().contains(projectPath) || !buildScope.getBuildPaths().contains(buildPath)) continue;
                    return buildScope;
                }
            }
        }
        return null;
    }

    Set<String> getDirectlyIncludedLabels(ResolutionScope resolutionScope) {
        return this.translate(resolutionScope).getDirectlyIncluded().stream().map(DependencyScope::getId).collect(Collectors.toSet());
    }

    Set<String> getDirectlyExcludedLabels(ResolutionScope resolutionScope) {
        ResolutionScopeImpl rs = this.translate(resolutionScope);
        return this.dependencyScopes.values().stream().filter(s -> !rs.getDirectlyIncluded().contains(s)).map(DependencyScope::getId).collect(Collectors.toSet());
    }

    Set<String> getTransitivelyExcludedLabels(ResolutionScope resolutionScope) {
        return this.translate(resolutionScope).getTransitivelyExcluded().stream().map(DependencyScope::getId).collect(Collectors.toSet());
    }

    Set<BuildScopeQuery> getPresence(DependencyScope dependencyScope) {
        return this.translate(dependencyScope).getPresence();
    }

    BuildScopeSource getBuildScopeSource() {
        return this.buildScopeSource;
    }

    private DependencyScopeImpl translate(DependencyScope dependencyScope) {
        return Objects.requireNonNull(this.dependencyScopes.get(dependencyScope.getId()), "unknown dependency scope");
    }

    private ResolutionScopeImpl translate(ResolutionScope resolutionScope) {
        return Objects.requireNonNull(this.resolutionScopes.get(resolutionScope.getId()), "unknown resolution scope");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeManagerImpl that = (ScopeManagerImpl)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }

    private class DependencyScopeImpl
    implements DependencyScope {
        private final String id;
        private final boolean transitive;
        private final Set<BuildScopeQuery> presence;
        private final BuildScope mainBuildScope;
        private final int width;

        private DependencyScopeImpl(String id, boolean transitive, Collection<BuildScopeQuery> presence) {
            this.id = Objects.requireNonNull(id, "id");
            this.transitive = transitive;
            this.presence = Collections.unmodifiableSet(new HashSet<BuildScopeQuery>(presence));
            this.mainBuildScope = ScopeManagerImpl.this.calculateMainProjectBuildScope(this);
            this.width = ScopeManagerImpl.this.calculateDependencyScopeWidth(this);
        }

        public String getId() {
            return this.id;
        }

        public boolean isTransitive() {
            return this.transitive;
        }

        public Set<BuildScopeQuery> getPresence() {
            return this.presence;
        }

        public BuildScope getMainBuildScope() {
            return this.mainBuildScope;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyScopeImpl that = (DependencyScopeImpl)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.id;
        }
    }

    private class ResolutionScopeImpl
    implements ResolutionScope {
        private final String id;
        private final InternalScopeManager.Mode mode;
        private final Set<BuildScopeQuery> wantedPresence;
        private final Set<DependencyScope> directlyIncluded;
        private final Set<DependencyScope> transitivelyExcluded;

        private ResolutionScopeImpl(String id, InternalScopeManager.Mode mode, Collection<BuildScopeQuery> wantedPresence, Collection<DependencyScope> explicitlyIncluded, Collection<DependencyScope> transitivelyExcluded) {
            this.id = Objects.requireNonNull(id, "id");
            this.mode = Objects.requireNonNull(mode, "mode");
            this.wantedPresence = Collections.unmodifiableSet(new HashSet<BuildScopeQuery>(wantedPresence));
            Set included = ScopeManagerImpl.this.collectScopes(wantedPresence);
            if (explicitlyIncluded != null && !explicitlyIncluded.isEmpty()) {
                explicitlyIncluded.stream().filter(Objects::nonNull).forEach(included::add);
            }
            this.directlyIncluded = Collections.unmodifiableSet(included);
            this.transitivelyExcluded = Collections.unmodifiableSet(transitivelyExcluded.stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        }

        public String getId() {
            return this.id;
        }

        public InternalScopeManager.Mode getMode() {
            return this.mode;
        }

        public Set<BuildScopeQuery> getWantedPresence() {
            return this.wantedPresence;
        }

        public Set<DependencyScope> getDirectlyIncluded() {
            return this.directlyIncluded;
        }

        public Set<DependencyScope> getTransitivelyExcluded() {
            return this.transitivelyExcluded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolutionScopeImpl that = (ResolutionScopeImpl)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.id;
        }
    }

    private class SystemDependencyScopeImpl
    extends DependencyScopeImpl
    implements SystemDependencyScope {
        private final String systemPathProperty;

        private SystemDependencyScopeImpl(String id, boolean transitive, Collection<BuildScopeQuery> presence, String systemPathProperty) {
            super(id, transitive, presence);
            this.systemPathProperty = Objects.requireNonNull(systemPathProperty);
        }

        public String getSystemPath(Artifact artifact) {
            return artifact.getProperty(this.systemPathProperty, null);
        }

        public void setSystemPath(Map<String, String> properties, String systemPath) {
            if (systemPath == null) {
                properties.remove(this.systemPathProperty);
            } else {
                properties.put(this.systemPathProperty, systemPath);
            }
        }
    }
}

