/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.impl.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultFileProcessor;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultOfflineController;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultTrackingFileManager;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.FileProvidedChecksumsSource;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector;
import org.eclipse.aether.internal.impl.collect.df.DfDependencyCollector;
import org.eclipse.aether.internal.impl.slf4j.Slf4jLoggerFactory;
import org.eclipse.aether.internal.impl.synccontext.legacy.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.synccontext.named.DiscriminatingNameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.FileGAVNameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.GAVNameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelector;
import org.eclipse.aether.internal.impl.synccontext.named.SimpleNamedLockFactorySelector;
import org.eclipse.aether.internal.impl.synccontext.named.StaticNameMapper;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.eclipse.aether.named.providers.NoopNamedLockFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.checksum.ProvidedChecksumsSource;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.slf4j.ILoggerFactory;

public class AetherModule
extends AbstractModule {
    protected void configure() {
        this.bind(RepositorySystem.class).to(DefaultRepositorySystem.class).in(Singleton.class);
        this.bind(ArtifactResolver.class).to(DefaultArtifactResolver.class).in(Singleton.class);
        this.bind(DependencyCollector.class).to(DefaultDependencyCollector.class).in(Singleton.class);
        this.bind(DependencyCollectorDelegate.class).annotatedWith((Annotation)Names.named((String)"bf")).to(BfDependencyCollector.class).in(Singleton.class);
        this.bind(DependencyCollectorDelegate.class).annotatedWith((Annotation)Names.named((String)"df")).to(DfDependencyCollector.class).in(Singleton.class);
        this.bind(Deployer.class).to(DefaultDeployer.class).in(Singleton.class);
        this.bind(Installer.class).to(DefaultInstaller.class).in(Singleton.class);
        this.bind(MetadataResolver.class).to(DefaultMetadataResolver.class).in(Singleton.class);
        this.bind(RepositoryLayoutProvider.class).to(DefaultRepositoryLayoutProvider.class).in(Singleton.class);
        this.bind(RepositoryLayoutFactory.class).annotatedWith((Annotation)Names.named((String)"maven2")).to(Maven2RepositoryLayoutFactory.class).in(Singleton.class);
        this.bind(TransporterProvider.class).to(DefaultTransporterProvider.class).in(Singleton.class);
        this.bind(ChecksumPolicyProvider.class).to(DefaultChecksumPolicyProvider.class).in(Singleton.class);
        this.bind(RepositoryConnectorProvider.class).to(DefaultRepositoryConnectorProvider.class).in(Singleton.class);
        this.bind(RemoteRepositoryManager.class).to(DefaultRemoteRepositoryManager.class).in(Singleton.class);
        this.bind(UpdateCheckManager.class).to(DefaultUpdateCheckManager.class).in(Singleton.class);
        this.bind(UpdatePolicyAnalyzer.class).to(DefaultUpdatePolicyAnalyzer.class).in(Singleton.class);
        this.bind(FileProcessor.class).to(DefaultFileProcessor.class).in(Singleton.class);
        this.bind(RepositoryEventDispatcher.class).to(DefaultRepositoryEventDispatcher.class).in(Singleton.class);
        this.bind(OfflineController.class).to(DefaultOfflineController.class).in(Singleton.class);
        this.bind(LocalPathComposer.class).to(DefaultLocalPathComposer.class).in(Singleton.class);
        this.bind(LocalPathPrefixComposerFactory.class).to(DefaultLocalPathPrefixComposerFactory.class).in(Singleton.class);
        this.bind(LocalRepositoryProvider.class).to(DefaultLocalRepositoryProvider.class).in(Singleton.class);
        this.bind(LocalRepositoryManagerFactory.class).annotatedWith((Annotation)Names.named((String)"simple")).to(SimpleLocalRepositoryManagerFactory.class).in(Singleton.class);
        this.bind(LocalRepositoryManagerFactory.class).annotatedWith((Annotation)Names.named((String)"enhanced")).to(EnhancedLocalRepositoryManagerFactory.class).in(Singleton.class);
        this.bind(TrackingFileManager.class).to(DefaultTrackingFileManager.class).in(Singleton.class);
        this.bind(ProvidedChecksumsSource.class).annotatedWith((Annotation)Names.named((String)"file")).to(FileProvidedChecksumsSource.class).in(Singleton.class);
        this.bind(ChecksumAlgorithmFactory.class).annotatedWith((Annotation)Names.named((String)"MD5")).to(Md5ChecksumAlgorithmFactory.class);
        this.bind(ChecksumAlgorithmFactory.class).annotatedWith((Annotation)Names.named((String)"SHA-1")).to(Sha1ChecksumAlgorithmFactory.class);
        this.bind(ChecksumAlgorithmFactory.class).annotatedWith((Annotation)Names.named((String)"SHA-256")).to(Sha256ChecksumAlgorithmFactory.class);
        this.bind(ChecksumAlgorithmFactory.class).annotatedWith((Annotation)Names.named((String)"SHA-512")).to(Sha512ChecksumAlgorithmFactory.class);
        this.bind(ChecksumAlgorithmFactorySelector.class).to(DefaultChecksumAlgorithmFactorySelector.class).in(Singleton.class);
        this.bind(NamedLockFactorySelector.class).to(SimpleNamedLockFactorySelector.class).in(Singleton.class);
        this.bind(org.eclipse.aether.spi.synccontext.SyncContextFactory.class).to(org.eclipse.aether.internal.impl.synccontext.DefaultSyncContextFactory.class).in(Singleton.class);
        this.bind(SyncContextFactory.class).to(DefaultSyncContextFactory.class).in(Singleton.class);
        this.bind(NameMapper.class).annotatedWith((Annotation)Names.named((String)"static")).to(StaticNameMapper.class).in(Singleton.class);
        this.bind(NameMapper.class).annotatedWith((Annotation)Names.named((String)"gav")).to(GAVNameMapper.class).in(Singleton.class);
        this.bind(NameMapper.class).annotatedWith((Annotation)Names.named((String)"discriminating")).to(DiscriminatingNameMapper.class).in(Singleton.class);
        this.bind(NameMapper.class).annotatedWith((Annotation)Names.named((String)"file-gav")).to(FileGAVNameMapper.class).in(Singleton.class);
        this.bind(NamedLockFactory.class).annotatedWith((Annotation)Names.named((String)"noop")).to(NoopNamedLockFactory.class).in(Singleton.class);
        this.bind(NamedLockFactory.class).annotatedWith((Annotation)Names.named((String)"rwlock-local")).to(LocalReadWriteLockNamedLockFactory.class).in(Singleton.class);
        this.bind(NamedLockFactory.class).annotatedWith((Annotation)Names.named((String)"semaphore-local")).to(LocalSemaphoreNamedLockFactory.class).in(Singleton.class);
        this.bind(NamedLockFactory.class).annotatedWith((Annotation)Names.named((String)"file-lock")).to(FileLockNamedLockFactory.class).in(Singleton.class);
        this.install((Module)new Slf4jModule());
    }

    @Provides
    @Singleton
    Map<String, DependencyCollectorDelegate> dependencyCollectorDelegates(@Named(value="bf") DependencyCollectorDelegate bf, @Named(value="df") DependencyCollectorDelegate df) {
        HashMap<String, DependencyCollectorDelegate> dependencyCollectorDelegates = new HashMap<String, DependencyCollectorDelegate>();
        dependencyCollectorDelegates.put("bf", bf);
        dependencyCollectorDelegates.put("df", df);
        return dependencyCollectorDelegates;
    }

    @Provides
    @Singleton
    Map<String, ProvidedChecksumsSource> provideChecksumSources(@Named(value="file") ProvidedChecksumsSource fileProvidedChecksumSource) {
        HashMap<String, ProvidedChecksumsSource> providedChecksumsSource = new HashMap<String, ProvidedChecksumsSource>();
        providedChecksumsSource.put("file", fileProvidedChecksumSource);
        return providedChecksumsSource;
    }

    @Provides
    @Singleton
    Map<String, ChecksumAlgorithmFactory> provideChecksumTypes(@Named(value="SHA-512") ChecksumAlgorithmFactory sha512, @Named(value="SHA-256") ChecksumAlgorithmFactory sha256, @Named(value="SHA-1") ChecksumAlgorithmFactory sha1, @Named(value="MD5") ChecksumAlgorithmFactory md5) {
        HashMap<String, ChecksumAlgorithmFactory> checksumTypes = new HashMap<String, ChecksumAlgorithmFactory>();
        checksumTypes.put("SHA-512", sha512);
        checksumTypes.put("SHA-256", sha256);
        checksumTypes.put("SHA-1", sha1);
        checksumTypes.put("MD5", md5);
        return Collections.unmodifiableMap(checksumTypes);
    }

    @Provides
    @Singleton
    Map<String, NameMapper> provideNameMappers(@Named(value="static") NameMapper staticNameMapper, @Named(value="gav") NameMapper gavNameMapper, @Named(value="discriminating") NameMapper discriminatingNameMapper, @Named(value="file-gav") NameMapper fileGavNameMapper) {
        HashMap<String, NameMapper> nameMappers = new HashMap<String, NameMapper>();
        nameMappers.put("static", staticNameMapper);
        nameMappers.put("gav", gavNameMapper);
        nameMappers.put("discriminating", discriminatingNameMapper);
        nameMappers.put("file-gav", fileGavNameMapper);
        return Collections.unmodifiableMap(nameMappers);
    }

    @Provides
    @Singleton
    Map<String, NamedLockFactory> provideNamedLockFactories(@Named(value="rwlock-local") NamedLockFactory localRwLock, @Named(value="semaphore-local") NamedLockFactory localSemaphore, @Named(value="file-lock") NamedLockFactory fileLockFactory) {
        HashMap<String, NamedLockFactory> factories = new HashMap<String, NamedLockFactory>();
        factories.put("rwlock-local", localRwLock);
        factories.put("semaphore-local", localSemaphore);
        factories.put("file-lock", fileLockFactory);
        return Collections.unmodifiableMap(factories);
    }

    @Provides
    @Singleton
    Set<LocalRepositoryManagerFactory> provideLocalRepositoryManagerFactories(@Named(value="simple") LocalRepositoryManagerFactory simple, @Named(value="enhanced") LocalRepositoryManagerFactory enhanced) {
        HashSet<LocalRepositoryManagerFactory> factories = new HashSet<LocalRepositoryManagerFactory>();
        factories.add(simple);
        factories.add(enhanced);
        return Collections.unmodifiableSet(factories);
    }

    @Provides
    @Singleton
    Set<RepositoryLayoutFactory> provideRepositoryLayoutFactories(@Named(value="maven2") RepositoryLayoutFactory maven2) {
        HashSet<RepositoryLayoutFactory> factories = new HashSet<RepositoryLayoutFactory>();
        factories.add(maven2);
        return Collections.unmodifiableSet(factories);
    }

    @Provides
    @Singleton
    Set<RepositoryListener> providesRepositoryListeners() {
        return Collections.emptySet();
    }

    private static class Slf4jModule
    extends AbstractModule {
        private Slf4jModule() {
        }

        protected void configure() {
            this.bind(LoggerFactory.class).to(Slf4jLoggerFactory.class);
        }

        @Provides
        @Singleton
        ILoggerFactory getLoggerFactory() {
            return org.slf4j.LoggerFactory.getILoggerFactory();
        }
    }
}

