/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.connector.basic.ArtifactTransportListener;
import org.eclipse.aether.connector.basic.ChecksumValidator;
import org.eclipse.aether.connector.basic.MetadataTransportListener;
import org.eclipse.aether.connector.basic.TransferTransportListener;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.FileUtils;
import org.eclipse.aether.util.concurrency.ExecutorUtils;
import org.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BasicRepositoryConnector
implements RepositoryConnector {
    private static final String CONFIG_PROP_THREADS = "aether.connector.basic.threads";
    private static final String CONFIG_PROP_SMART_CHECKSUMS = "aether.connector.smartChecksums";
    private static final String CONFIG_PROP_PARALLEL_PUT = "aether.connector.basic.parallelPut";
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRepositoryConnector.class);
    private final Map<String, ProvidedChecksumsSource> providedChecksumsSources;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final Transporter transporter;
    private final RepositoryLayout layout;
    private final ChecksumPolicyProvider checksumPolicyProvider;
    private final int maxThreads;
    private final boolean smartChecksums;
    private final boolean parallelPut;
    private final boolean persistedChecksums;
    private Executor executor;
    private final AtomicBoolean closed;

    BasicRepositoryConnector(RepositorySystemSession session, RemoteRepository repository, TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) throws NoRepositoryConnectorException {
        try {
            this.layout = layoutProvider.newRepositoryLayout(session, repository);
        }
        catch (NoRepositoryLayoutException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), (Throwable)e);
        }
        try {
            this.transporter = transporterProvider.newTransporter(session, repository);
        }
        catch (NoTransporterException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), (Throwable)e);
        }
        this.checksumPolicyProvider = checksumPolicyProvider;
        this.session = session;
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.providedChecksumsSources = providedChecksumsSources;
        this.closed = new AtomicBoolean(false);
        this.maxThreads = ExecutorUtils.threadCount((RepositorySystemSession)session, (int)5, (String[])new String[]{CONFIG_PROP_THREADS, "maven.artifact.threads"});
        this.smartChecksums = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_SMART_CHECKSUMS});
        this.parallelPut = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.connector.basic.parallelPut." + repository.getId(), CONFIG_PROP_PARALLEL_PUT});
        this.persistedChecksums = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.connector.persistedChecksums"});
    }

    private Executor getExecutor(int tasks) {
        if (this.maxThreads <= 1) {
            return ExecutorUtils.DIRECT_EXECUTOR;
        }
        if (tasks <= 1) {
            return ExecutorUtils.DIRECT_EXECUTOR;
        }
        if (this.executor == null) {
            this.executor = ExecutorUtils.threadPool((int)this.maxThreads, (String)(this.getClass().getSimpleName() + '-' + this.repository.getHost() + '-'));
        }
        return this.executor;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ExecutorUtils.shutdown((Executor)this.executor);
            this.transporter.close();
        }
    }

    private void failIfClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("connector already closed");
        }
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        this.failIfClosed();
        Collection<? extends ArtifactDownload> safeArtifactDownloads = BasicRepositoryConnector.safe(artifactDownloads);
        Collection<? extends MetadataDownload> safeMetadataDownloads = BasicRepositoryConnector.safe(metadataDownloads);
        Executor executor = this.getExecutor(safeArtifactDownloads.size() + safeMetadataDownloads.size());
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        List checksumAlgorithmFactories = this.layout.getChecksumAlgorithmFactories();
        boolean first = true;
        for (MetadataDownload metadataDownload : safeMetadataDownloads) {
            URI location = this.layout.getLocation(metadataDownload.getMetadata(), false);
            TransferResource resource = this.newTransferResource(location, metadataDownload.getFile(), metadataDownload.getTrace());
            TransferEvent.Builder builder = this.newEventBuilder(resource, false, false);
            MetadataTransportListener listener = new MetadataTransportListener((MetadataTransfer)metadataDownload, this.repository, builder);
            ChecksumPolicy checksumPolicy = this.newChecksumPolicy(metadataDownload.getChecksumPolicy(), resource);
            List checksumLocations = null;
            if (checksumPolicy != null) {
                checksumLocations = this.layout.getChecksumLocations(metadataDownload.getMetadata(), false, location);
            }
            GetTaskRunner task = new GetTaskRunner(location, metadataDownload.getFile(), checksumPolicy, checksumAlgorithmFactories, checksumLocations, null, listener);
            if (first) {
                task.run();
                first = false;
                continue;
            }
            executor.execute(errorForwarder.wrap((Runnable)task));
        }
        for (ArtifactDownload artifactDownload : safeArtifactDownloads) {
            TaskRunner task;
            Map providedChecksums = Collections.emptyMap();
            for (ProvidedChecksumsSource providedChecksumsSource : this.providedChecksumsSources.values()) {
                Map provided = providedChecksumsSource.getProvidedArtifactChecksums(this.session, artifactDownload, this.repository, checksumAlgorithmFactories);
                if (provided == null) continue;
                providedChecksums = provided;
                break;
            }
            URI location = this.layout.getLocation(artifactDownload.getArtifact(), false);
            TransferResource resource = this.newTransferResource(location, artifactDownload.getFile(), artifactDownload.getTrace());
            TransferEvent.Builder builder = this.newEventBuilder(resource, false, artifactDownload.isExistenceCheck());
            ArtifactTransportListener listener = new ArtifactTransportListener((ArtifactTransfer)artifactDownload, this.repository, builder);
            if (artifactDownload.isExistenceCheck()) {
                task = new PeekTaskRunner(location, listener);
            } else {
                ChecksumPolicy checksumPolicy = this.newChecksumPolicy(artifactDownload.getChecksumPolicy(), resource);
                List checksumLocations = null;
                if (checksumPolicy != null) {
                    checksumLocations = this.layout.getChecksumLocations(artifactDownload.getArtifact(), false, location);
                }
                task = new GetTaskRunner(location, artifactDownload.getFile(), checksumPolicy, checksumAlgorithmFactories, checksumLocations, providedChecksums, listener);
            }
            if (first) {
                task.run();
                first = false;
                continue;
            }
            executor.execute(errorForwarder.wrap((Runnable)task));
        }
        errorForwarder.await();
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        this.failIfClosed();
        Collection<? extends ArtifactUpload> safeArtifactUploads = BasicRepositoryConnector.safe(artifactUploads);
        Collection<? extends MetadataUpload> safeMetadataUploads = BasicRepositoryConnector.safe(metadataUploads);
        Executor executor = this.getExecutor(this.parallelPut ? safeArtifactUploads.size() + safeMetadataUploads.size() : 1);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        boolean first = true;
        for (ArtifactUpload artifactUpload : safeArtifactUploads) {
            URI location = this.layout.getLocation(artifactUpload.getArtifact(), true);
            TransferResource resource = this.newTransferResource(location, artifactUpload.getFile(), artifactUpload.getTrace());
            TransferEvent.Builder builder = this.newEventBuilder(resource, true, false);
            ArtifactTransportListener listener = new ArtifactTransportListener((ArtifactTransfer)artifactUpload, this.repository, builder);
            List checksumLocations = this.layout.getChecksumLocations(artifactUpload.getArtifact(), true, location);
            PutTaskRunner task = new PutTaskRunner(location, artifactUpload.getFile(), checksumLocations, listener);
            if (first) {
                task.run();
                first = false;
                continue;
            }
            executor.execute(errorForwarder.wrap((Runnable)task));
        }
        errorForwarder.await();
        for (List list : BasicRepositoryConnector.groupUploads(safeMetadataUploads)) {
            for (MetadataUpload transfer : list) {
                URI location = this.layout.getLocation(transfer.getMetadata(), true);
                TransferResource resource = this.newTransferResource(location, transfer.getFile(), transfer.getTrace());
                TransferEvent.Builder builder = this.newEventBuilder(resource, true, false);
                MetadataTransportListener listener = new MetadataTransportListener((MetadataTransfer)transfer, this.repository, builder);
                List checksumLocations = this.layout.getChecksumLocations(transfer.getMetadata(), true, location);
                PutTaskRunner task = new PutTaskRunner(location, transfer.getFile(), checksumLocations, listener);
                if (first) {
                    task.run();
                    first = false;
                    continue;
                }
                executor.execute(errorForwarder.wrap((Runnable)task));
            }
            errorForwarder.await();
        }
    }

    private static List<List<MetadataUpload>> groupUploads(Collection<? extends MetadataUpload> metadataUploads) {
        ArrayList<MetadataUpload> v = new ArrayList<MetadataUpload>();
        ArrayList<MetadataUpload> a = new ArrayList<MetadataUpload>();
        ArrayList<MetadataUpload> g = new ArrayList<MetadataUpload>();
        ArrayList<MetadataUpload> r = new ArrayList<MetadataUpload>();
        for (MetadataUpload metadataUpload : metadataUploads) {
            Metadata metadata = metadataUpload.getMetadata();
            if (!"".equals(metadata.getVersion())) {
                v.add(metadataUpload);
                continue;
            }
            if (!"".equals(metadata.getArtifactId())) {
                a.add(metadataUpload);
                continue;
            }
            if (!"".equals(metadata.getGroupId())) {
                g.add(metadataUpload);
                continue;
            }
            r.add(metadataUpload);
        }
        ArrayList<List<MetadataUpload>> result = new ArrayList<List<MetadataUpload>>(4);
        if (!v.isEmpty()) {
            result.add(v);
        }
        if (!a.isEmpty()) {
            result.add(a);
        }
        if (!g.isEmpty()) {
            result.add(g);
        }
        if (!r.isEmpty()) {
            result.add(r);
        }
        return result;
    }

    private static <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private TransferResource newTransferResource(URI path, File file, RequestTrace trace) {
        return new TransferResource(this.repository.getId(), this.repository.getUrl(), path.toString(), file, trace);
    }

    private TransferEvent.Builder newEventBuilder(TransferResource resource, boolean upload, boolean peek) {
        TransferEvent.Builder builder = new TransferEvent.Builder(this.session, resource);
        if (upload) {
            builder.setRequestType(TransferEvent.RequestType.PUT);
        } else if (!peek) {
            builder.setRequestType(TransferEvent.RequestType.GET);
        } else {
            builder.setRequestType(TransferEvent.RequestType.GET_EXISTENCE);
        }
        return builder;
    }

    private ChecksumPolicy newChecksumPolicy(String policy, TransferResource resource) {
        return this.checksumPolicyProvider.newChecksumPolicy(this.session, this.repository, resource, policy);
    }

    public String toString() {
        return String.valueOf(this.repository);
    }

    class GetTaskRunner
    extends TaskRunner
    implements ChecksumValidator.ChecksumFetcher {
        private final File file;
        private final ChecksumValidator checksumValidator;

        GetTaskRunner(URI path, File file, ChecksumPolicy checksumPolicy, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories, List<RepositoryLayout.ChecksumLocation> checksumLocations, Map<String, String> providedChecksums, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = Objects.requireNonNull(file, "destination file cannot be null");
            this.checksumValidator = new ChecksumValidator(file, checksumAlgorithmFactories, BasicRepositoryConnector.this.fileProcessor, this, checksumPolicy, providedChecksums, BasicRepositoryConnector.safe(checksumLocations));
        }

        @Override
        public boolean fetchChecksum(URI remote, File local) throws Exception {
            try {
                BasicRepositoryConnector.this.transporter.get(new GetTask(remote).setDataFile(local));
            }
            catch (Exception e) {
                if (BasicRepositoryConnector.this.transporter.classify((Throwable)e) == 1) {
                    return false;
                }
                throw e;
            }
            return true;
        }

        @Override
        protected void runTask() throws Exception {
            try (FileUtils.CollocatedTempFile tempFile = FileUtils.newTempFile((Path)this.file.toPath());){
                File tmp = tempFile.getPath().toFile();
                this.listener.setChecksumCalculator(this.checksumValidator.newChecksumCalculator(tmp));
                int firstTrial = 0;
                int lastTrial = 1;
                int trial = firstTrial;
                while (true) {
                    GetTask task = new GetTask(this.path).setDataFile(tmp, false).setListener((TransportListener)this.listener);
                    BasicRepositoryConnector.this.transporter.get(task);
                    try {
                        this.checksumValidator.validate(this.listener.getChecksums(), BasicRepositoryConnector.this.smartChecksums ? task.getChecksums() : null);
                    }
                    catch (ChecksumFailureException e) {
                        boolean retry;
                        boolean bl = retry = trial < lastTrial && e.isRetryWorthy();
                        if (!retry && !this.checksumValidator.handle(e)) {
                            throw e;
                        }
                        this.listener.transferCorrupted((Exception)((Object)e));
                        if (!retry) break;
                        this.checksumValidator.retry();
                        ++trial;
                        continue;
                    }
                    break;
                }
                tempFile.move();
                if (BasicRepositoryConnector.this.persistedChecksums) {
                    this.checksumValidator.commit();
                }
            }
        }
    }

    class PeekTaskRunner
    extends TaskRunner {
        PeekTaskRunner(URI path, TransferTransportListener<?> listener) {
            super(path, listener);
        }

        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }
    }

    class PutTaskRunner
    extends TaskRunner {
        private final File file;
        private final Collection<RepositoryLayout.ChecksumLocation> checksumLocations;

        PutTaskRunner(URI path, File file, List<RepositoryLayout.ChecksumLocation> checksumLocations, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = Objects.requireNonNull(file, "source file cannot be null");
            this.checksumLocations = BasicRepositoryConnector.safe(checksumLocations);
        }

        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.transporter.put(new PutTask(this.path).setDataFile(this.file).setListener((TransportListener)this.listener));
            this.uploadChecksums(this.file, null);
        }

        private void uploadChecksums(File file, byte[] bytes) {
            if (this.checksumLocations.isEmpty()) {
                return;
            }
            try {
                ArrayList<ChecksumAlgorithmFactory> algorithms = new ArrayList<ChecksumAlgorithmFactory>();
                for (RepositoryLayout.ChecksumLocation checksumLocation : this.checksumLocations) {
                    algorithms.add(checksumLocation.getChecksumAlgorithmFactory());
                }
                Map sumsByAlgo = bytes != null ? ChecksumAlgorithmHelper.calculate((byte[])bytes, algorithms) : ChecksumAlgorithmHelper.calculate((File)file, algorithms);
                for (RepositoryLayout.ChecksumLocation checksumLocation : this.checksumLocations) {
                    this.uploadChecksum(checksumLocation.getLocation(), sumsByAlgo.get(checksumLocation.getChecksumAlgorithmFactory().getName()));
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to upload checksums for {}", (Object)file, (Object)e);
                throw new UncheckedIOException(e);
            }
        }

        private void uploadChecksum(URI location, Object checksum) {
            try {
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                BasicRepositoryConnector.this.transporter.put(new PutTask(location).setDataString((String)checksum));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to upload checksum to {}", (Object)location, (Object)e);
            }
        }
    }

    abstract class TaskRunner
    implements Runnable {
        protected final URI path;
        protected final TransferTransportListener<?> listener;

        TaskRunner(URI path, TransferTransportListener<?> listener) {
            this.path = path;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.listener.transferInitiated();
                this.runTask();
                this.listener.transferSucceeded();
            }
            catch (Exception e) {
                this.listener.transferFailed(e, BasicRepositoryConnector.this.transporter.classify((Throwable)e));
            }
        }

        protected abstract void runTask() throws Exception;
    }
}

