/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.transfer.ArtifactNotFoundException;

public final class ArtifactResult {
    public static final ArtifactRepository NO_REPOSITORY = new NoRepository();
    private final ArtifactRequest request;
    private final Map<ArtifactRepository, List<Exception>> exceptions;
    private Artifact artifact;
    private ArtifactRepository repository;
    private LocalArtifactResult localArtifactResult;

    public ArtifactResult(ArtifactRequest request) {
        this.request = Objects.requireNonNull(request, "artifact request cannot be null");
        this.exceptions = new ConcurrentHashMap<ArtifactRepository, List<Exception>>();
    }

    public ArtifactRequest getRequest() {
        return this.request;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public List<Exception> getExceptions() {
        ArrayList<Exception> result = new ArrayList<Exception>();
        this.exceptions.values().forEach(result::addAll);
        return result;
    }

    public Map<ArtifactRepository, List<Exception>> getMappedExceptions() {
        return this.exceptions;
    }

    @Deprecated
    public ArtifactResult addException(Exception exception) {
        return this.addException(NO_REPOSITORY, exception);
    }

    public ArtifactResult addException(ArtifactRepository repository, Exception exception) {
        if (repository != null && exception != null) {
            this.exceptions.computeIfAbsent(repository, k -> new CopyOnWriteArrayList()).add(exception);
        }
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactResult setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public LocalArtifactResult getLocalArtifactResult() {
        return this.localArtifactResult;
    }

    public void setLocalArtifactResult(LocalArtifactResult localArtifactResult) {
        this.localArtifactResult = localArtifactResult;
    }

    public boolean isResolved() {
        return this.getArtifact() != null && this.getArtifact().getPath() != null;
    }

    public boolean isMissing() {
        for (Exception e : this.getExceptions()) {
            if (e instanceof ArtifactNotFoundException) continue;
            return false;
        }
        return !this.isResolved();
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepository();
    }

    private static final class NoRepository
    implements ArtifactRepository {
        private NoRepository() {
        }

        @Override
        public String getContentType() {
            return "unknown";
        }

        @Override
        public String getId() {
            return "unknown";
        }

        public String toString() {
            return this.getId();
        }
    }
}

