/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.util.Objects;
import java.util.UUID;
import org.eclipse.aether.repository.ArtifactRepository;

public final class WorkspaceRepository
implements ArtifactRepository {
    public static final String ID = "workspace";
    private final String type;
    private final Object key;
    private final int hashCode;

    public WorkspaceRepository() {
        this(ID);
    }

    public WorkspaceRepository(String type) {
        this(type, null);
    }

    public WorkspaceRepository(String type, Object key) {
        this.type = type != null ? type : "";
        this.key = key != null ? key : UUID.randomUUID().toString().replace("-", "");
        this.hashCode = Objects.hash(type, key);
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return ID;
    }

    public Object getKey() {
        return this.key;
    }

    public String toString() {
        return "(" + this.getContentType() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        WorkspaceRepository that = (WorkspaceRepository)obj;
        return this.getContentType().equals(that.getContentType()) && this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return this.hashCode;
    }
}

