/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.aether.DefaultSessionData;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferListener;

public final class DefaultRepositorySystemSession
implements RepositorySystemSession {
    private boolean readOnly;
    private boolean offline;
    private boolean ignoreArtifactDescriptorRepositories;
    private ResolutionErrorPolicy resolutionErrorPolicy;
    private ArtifactDescriptorPolicy artifactDescriptorPolicy;
    private String checksumPolicy;
    private String artifactUpdatePolicy;
    private String metadataUpdatePolicy;
    private LocalRepositoryManager localRepositoryManager;
    private WorkspaceReader workspaceReader;
    private RepositoryListener repositoryListener;
    private TransferListener transferListener;
    private Map<String, String> systemProperties;
    private Map<String, String> systemPropertiesView;
    private Map<String, String> userProperties;
    private Map<String, String> userPropertiesView;
    private Map<String, Object> configProperties;
    private Map<String, Object> configPropertiesView;
    private MirrorSelector mirrorSelector;
    private ProxySelector proxySelector;
    private AuthenticationSelector authenticationSelector;
    private ArtifactTypeRegistry artifactTypeRegistry;
    private DependencyTraverser dependencyTraverser;
    private DependencyManager dependencyManager;
    private DependencySelector dependencySelector;
    private VersionFilter versionFilter;
    private DependencyGraphTransformer dependencyGraphTransformer;
    private SessionData data;
    private RepositoryCache cache;
    private final Function<Runnable, Boolean> onSessionEndedRegistrar;

    @Deprecated
    public DefaultRepositorySystemSession() {
        this((Runnable h) -> false);
    }

    public DefaultRepositorySystemSession(Function<Runnable, Boolean> onSessionEndedRegistrar) {
        this.systemProperties = new HashMap<String, String>();
        this.systemPropertiesView = Collections.unmodifiableMap(this.systemProperties);
        this.userProperties = new HashMap<String, String>();
        this.userPropertiesView = Collections.unmodifiableMap(this.userProperties);
        this.configProperties = new HashMap<String, Object>();
        this.configPropertiesView = Collections.unmodifiableMap(this.configProperties);
        this.mirrorSelector = NullMirrorSelector.INSTANCE;
        this.proxySelector = NullProxySelector.INSTANCE;
        this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        this.data = new DefaultSessionData();
        this.onSessionEndedRegistrar = Objects.requireNonNull(onSessionEndedRegistrar, "onSessionEndedRegistrar");
    }

    public DefaultRepositorySystemSession(RepositorySystemSession session) {
        Objects.requireNonNull(session, "repository system session cannot be null");
        this.setOffline(session.isOffline());
        this.setIgnoreArtifactDescriptorRepositories(session.isIgnoreArtifactDescriptorRepositories());
        this.setResolutionErrorPolicy(session.getResolutionErrorPolicy());
        this.setArtifactDescriptorPolicy(session.getArtifactDescriptorPolicy());
        this.setChecksumPolicy(session.getChecksumPolicy());
        this.setUpdatePolicy(session.getUpdatePolicy());
        this.setMetadataUpdatePolicy(session.getMetadataUpdatePolicy());
        this.setLocalRepositoryManager(session.getLocalRepositoryManager());
        this.setWorkspaceReader(session.getWorkspaceReader());
        this.setRepositoryListener(session.getRepositoryListener());
        this.setTransferListener(session.getTransferListener());
        this.setSystemProperties(session.getSystemProperties());
        this.setUserProperties(session.getUserProperties());
        this.setConfigProperties(session.getConfigProperties());
        this.setMirrorSelector(session.getMirrorSelector());
        this.setProxySelector(session.getProxySelector());
        this.setAuthenticationSelector(session.getAuthenticationSelector());
        this.setArtifactTypeRegistry(session.getArtifactTypeRegistry());
        this.setDependencyTraverser(session.getDependencyTraverser());
        this.setDependencyManager(session.getDependencyManager());
        this.setDependencySelector(session.getDependencySelector());
        this.setVersionFilter(session.getVersionFilter());
        this.setDependencyGraphTransformer(session.getDependencyGraphTransformer());
        this.setData(session.getData());
        this.setCache(session.getCache());
        this.onSessionEndedRegistrar = session::addOnSessionEndedHandler;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    public DefaultRepositorySystemSession setOffline(boolean offline) {
        this.verifyStateForMutation();
        this.offline = offline;
        return this;
    }

    @Override
    public boolean isIgnoreArtifactDescriptorRepositories() {
        return this.ignoreArtifactDescriptorRepositories;
    }

    public DefaultRepositorySystemSession setIgnoreArtifactDescriptorRepositories(boolean ignoreArtifactDescriptorRepositories) {
        this.verifyStateForMutation();
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        return this;
    }

    @Override
    public ResolutionErrorPolicy getResolutionErrorPolicy() {
        return this.resolutionErrorPolicy;
    }

    public DefaultRepositorySystemSession setResolutionErrorPolicy(ResolutionErrorPolicy resolutionErrorPolicy) {
        this.verifyStateForMutation();
        this.resolutionErrorPolicy = resolutionErrorPolicy;
        return this;
    }

    @Override
    public ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return this.artifactDescriptorPolicy;
    }

    public DefaultRepositorySystemSession setArtifactDescriptorPolicy(ArtifactDescriptorPolicy artifactDescriptorPolicy) {
        this.verifyStateForMutation();
        this.artifactDescriptorPolicy = artifactDescriptorPolicy;
        return this;
    }

    @Override
    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public DefaultRepositorySystemSession setChecksumPolicy(String checksumPolicy) {
        this.verifyStateForMutation();
        this.checksumPolicy = checksumPolicy;
        return this;
    }

    @Override
    public String getUpdatePolicy() {
        return this.getArtifactUpdatePolicy();
    }

    public DefaultRepositorySystemSession setUpdatePolicy(String updatePolicy) {
        this.verifyStateForMutation();
        this.setArtifactUpdatePolicy(updatePolicy);
        this.setMetadataUpdatePolicy(updatePolicy);
        return this;
    }

    @Override
    public String getArtifactUpdatePolicy() {
        return this.artifactUpdatePolicy;
    }

    public DefaultRepositorySystemSession setArtifactUpdatePolicy(String artifactUpdatePolicy) {
        this.verifyStateForMutation();
        this.artifactUpdatePolicy = artifactUpdatePolicy;
        return this;
    }

    @Override
    public String getMetadataUpdatePolicy() {
        return this.metadataUpdatePolicy;
    }

    public DefaultRepositorySystemSession setMetadataUpdatePolicy(String metadataUpdatePolicy) {
        this.verifyStateForMutation();
        this.metadataUpdatePolicy = metadataUpdatePolicy;
        return this;
    }

    @Override
    public LocalRepository getLocalRepository() {
        LocalRepositoryManager lrm = this.getLocalRepositoryManager();
        return lrm != null ? lrm.getRepository() : null;
    }

    @Override
    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepositoryManager;
    }

    public DefaultRepositorySystemSession setLocalRepositoryManager(LocalRepositoryManager localRepositoryManager) {
        this.verifyStateForMutation();
        this.localRepositoryManager = localRepositoryManager;
        return this;
    }

    @Override
    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    public DefaultRepositorySystemSession setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.verifyStateForMutation();
        this.workspaceReader = workspaceReader;
        return this;
    }

    @Override
    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public DefaultRepositorySystemSession setRepositoryListener(RepositoryListener repositoryListener) {
        this.verifyStateForMutation();
        this.repositoryListener = repositoryListener;
        return this;
    }

    @Override
    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public DefaultRepositorySystemSession setTransferListener(TransferListener transferListener) {
        this.verifyStateForMutation();
        this.transferListener = transferListener;
        return this;
    }

    private <T> Map<String, T> copySafe(Map<?, ?> table, Class<T> valueType) {
        HashMap<String, T> map;
        if (table == null || table.isEmpty()) {
            map = new HashMap<String, T>();
        } else {
            map = new HashMap((int)((float)table.size() / 0.75f) + 1);
            for (Map.Entry<?, ?> entry : table.entrySet()) {
                Object value;
                Object key = entry.getKey();
                if (!(key instanceof String) || !valueType.isInstance(value = entry.getValue())) continue;
                map.put(key.toString(), valueType.cast(value));
            }
        }
        return map;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemPropertiesView;
    }

    public DefaultRepositorySystemSession setSystemProperties(Map<?, ?> systemProperties) {
        this.verifyStateForMutation();
        this.systemProperties = this.copySafe(systemProperties, String.class);
        this.systemPropertiesView = Collections.unmodifiableMap(this.systemProperties);
        return this;
    }

    public DefaultRepositorySystemSession setSystemProperty(String key, String value) {
        this.verifyStateForMutation();
        if (value != null) {
            this.systemProperties.put(key, value);
        } else {
            this.systemProperties.remove(key);
        }
        return this;
    }

    @Override
    public Map<String, String> getUserProperties() {
        return this.userPropertiesView;
    }

    public DefaultRepositorySystemSession setUserProperties(Map<?, ?> userProperties) {
        this.verifyStateForMutation();
        this.userProperties = this.copySafe(userProperties, String.class);
        this.userPropertiesView = Collections.unmodifiableMap(this.userProperties);
        return this;
    }

    public DefaultRepositorySystemSession setUserProperty(String key, String value) {
        this.verifyStateForMutation();
        if (value != null) {
            this.userProperties.put(key, value);
        } else {
            this.userProperties.remove(key);
        }
        return this;
    }

    @Override
    public Map<String, Object> getConfigProperties() {
        return this.configPropertiesView;
    }

    public DefaultRepositorySystemSession setConfigProperties(Map<?, ?> configProperties) {
        this.verifyStateForMutation();
        this.configProperties = this.copySafe(configProperties, Object.class);
        this.configPropertiesView = Collections.unmodifiableMap(this.configProperties);
        return this;
    }

    public DefaultRepositorySystemSession setConfigProperty(String key, Object value) {
        this.verifyStateForMutation();
        if (value != null) {
            this.configProperties.put(key, value);
        } else {
            this.configProperties.remove(key);
        }
        return this;
    }

    @Override
    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public DefaultRepositorySystemSession setMirrorSelector(MirrorSelector mirrorSelector) {
        this.verifyStateForMutation();
        this.mirrorSelector = mirrorSelector;
        if (this.mirrorSelector == null) {
            this.mirrorSelector = NullMirrorSelector.INSTANCE;
        }
        return this;
    }

    @Override
    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public DefaultRepositorySystemSession setProxySelector(ProxySelector proxySelector) {
        this.verifyStateForMutation();
        this.proxySelector = proxySelector;
        if (this.proxySelector == null) {
            this.proxySelector = NullProxySelector.INSTANCE;
        }
        return this;
    }

    @Override
    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public DefaultRepositorySystemSession setAuthenticationSelector(AuthenticationSelector authenticationSelector) {
        this.verifyStateForMutation();
        this.authenticationSelector = authenticationSelector;
        if (this.authenticationSelector == null) {
            this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        }
        return this;
    }

    @Override
    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    public DefaultRepositorySystemSession setArtifactTypeRegistry(ArtifactTypeRegistry artifactTypeRegistry) {
        this.verifyStateForMutation();
        this.artifactTypeRegistry = artifactTypeRegistry;
        if (this.artifactTypeRegistry == null) {
            this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        }
        return this;
    }

    @Override
    public DependencyTraverser getDependencyTraverser() {
        return this.dependencyTraverser;
    }

    public DefaultRepositorySystemSession setDependencyTraverser(DependencyTraverser dependencyTraverser) {
        this.verifyStateForMutation();
        this.dependencyTraverser = dependencyTraverser;
        return this;
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public DefaultRepositorySystemSession setDependencyManager(DependencyManager dependencyManager) {
        this.verifyStateForMutation();
        this.dependencyManager = dependencyManager;
        return this;
    }

    @Override
    public DependencySelector getDependencySelector() {
        return this.dependencySelector;
    }

    public DefaultRepositorySystemSession setDependencySelector(DependencySelector dependencySelector) {
        this.verifyStateForMutation();
        this.dependencySelector = dependencySelector;
        return this;
    }

    @Override
    public VersionFilter getVersionFilter() {
        return this.versionFilter;
    }

    public DefaultRepositorySystemSession setVersionFilter(VersionFilter versionFilter) {
        this.verifyStateForMutation();
        this.versionFilter = versionFilter;
        return this;
    }

    @Override
    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public DefaultRepositorySystemSession setDependencyGraphTransformer(DependencyGraphTransformer dependencyGraphTransformer) {
        this.verifyStateForMutation();
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        return this;
    }

    @Override
    public SessionData getData() {
        return this.data;
    }

    public DefaultRepositorySystemSession setData(SessionData data) {
        this.verifyStateForMutation();
        this.data = data;
        if (this.data == null) {
            this.data = new DefaultSessionData();
        }
        return this;
    }

    @Override
    public RepositoryCache getCache() {
        return this.cache;
    }

    public DefaultRepositorySystemSession setCache(RepositoryCache cache) {
        this.verifyStateForMutation();
        this.cache = cache;
        return this;
    }

    @Override
    public boolean addOnSessionEndedHandler(Runnable handler) {
        return this.onSessionEndedRegistrar.apply(handler);
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    private void verifyStateForMutation() {
        if (this.readOnly) {
            throw new IllegalStateException("repository system session is read-only");
        }
    }

    static class NullMirrorSelector
    implements MirrorSelector {
        public static final MirrorSelector INSTANCE = new NullMirrorSelector();

        NullMirrorSelector() {
        }

        @Override
        public RemoteRepository getMirror(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return null;
        }
    }

    static class NullProxySelector
    implements ProxySelector {
        public static final ProxySelector INSTANCE = new NullProxySelector();

        NullProxySelector() {
        }

        @Override
        public Proxy getProxy(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return repository.getProxy();
        }
    }

    static class NullAuthenticationSelector
    implements AuthenticationSelector {
        public static final AuthenticationSelector INSTANCE = new NullAuthenticationSelector();

        NullAuthenticationSelector() {
        }

        @Override
        public Authentication getAuthentication(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return repository.getAuthentication();
        }
    }

    static final class NullArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        public static final ArtifactTypeRegistry INSTANCE = new NullArtifactTypeRegistry();

        NullArtifactTypeRegistry() {
        }

        @Override
        public ArtifactType get(String typeId) {
            return null;
        }
    }
}

