/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;

public abstract class AbstractScmCommitPhase
extends AbstractReleasePhase {
    protected final ScmRepositoryConfigurator scmRepositoryConfigurator;
    protected final String descriptorCommentGetter;
    private final Set<String> exclusionPatterns = new HashSet<String>();

    protected AbstractScmCommitPhase(ScmRepositoryConfigurator scmRepositoryConfigurator, String descriptorCommentGetter) {
        this.scmRepositoryConfigurator = Objects.requireNonNull(scmRepositoryConfigurator);
        this.descriptorCommentGetter = Objects.requireNonNull(descriptorCommentGetter);
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult relResult = new ReleaseResult();
        this.validateConfiguration(releaseDescriptor);
        List additionalExcludes = releaseDescriptor.getCheckModificationExcludes();
        if (additionalExcludes != null) {
            this.exclusionPatterns.addAll(additionalExcludes);
        }
        this.runLogic(releaseDescriptor, releaseEnvironment, reactorProjects, relResult, false);
        relResult.setResultCode(0);
        return relResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.validateConfiguration(releaseDescriptor);
        this.runLogic(releaseDescriptor, releaseEnvironment, reactorProjects, result, true);
        result.setResultCode(0);
        return result;
    }

    protected abstract void runLogic(ReleaseDescriptor var1, ReleaseEnvironment var2, List<MavenProject> var3, ReleaseResult var4, boolean var5) throws ReleaseScmCommandException, ReleaseExecutionException, ReleaseScmRepositoryException;

    protected void performCheckins(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, String message) throws ReleaseScmRepositoryException, ReleaseExecutionException, ReleaseScmCommandException {
        ScmProvider provider;
        ScmRepository repository;
        this.getLogger().info("Checking in modified POMs...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            repository.getProviderRepository().setPushChanges(releaseDescriptor.isPushChanges());
            repository.getProviderRepository().setWorkItem(releaseDescriptor.getWorkItem());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
        }
        if (releaseDescriptor.isCommitByProject()) {
            for (MavenProject project : reactorProjects) {
                List<File> pomFiles = AbstractScmCommitPhase.createPomFiles(releaseDescriptor, project);
                ScmFileSet fileSet = new ScmFileSet(project.getFile().getParentFile(), pomFiles);
                this.checkin(provider, repository, fileSet, releaseDescriptor, message);
            }
        } else {
            List<File> pomFiles = this.createPomFiles(releaseDescriptor, reactorProjects);
            if (!pomFiles.isEmpty()) {
                ScmFileSet fileSet = new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), pomFiles);
                this.checkin(provider, repository, fileSet, releaseDescriptor, message);
            }
        }
    }

    private void checkin(ScmProvider provider, ScmRepository repository, ScmFileSet fileSet, ReleaseDescriptor releaseDescriptor, String message) throws ReleaseExecutionException, ReleaseScmCommandException {
        CheckInScmResult result;
        try {
            result = provider.checkIn(repository, fileSet, (ScmVersion)null, message);
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the checkin process: " + e.getMessage(), (Throwable)e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to commit files", (ScmResult)result);
        }
        if (releaseDescriptor.isRemoteTagging()) {
            releaseDescriptor.setScmReleasedPomRevision(result.getScmRevision());
        }
    }

    protected void simulateCheckins(ReleaseDescriptor releaseDescriptor, List<MavenProject> reactorProjects, ReleaseResult result, String message) {
        List<File> pomFiles = this.createPomFiles(releaseDescriptor, reactorProjects);
        this.logInfo(result, "Full run would be commit " + pomFiles.size() + " files with message: '" + message + "'");
    }

    protected void validateConfiguration(ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException {
        if (releaseDescriptor.getScmReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for committing");
        }
    }

    protected String createMessage(List<MavenProject> reactorProjects, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException {
        String comment;
        boolean branch = false;
        if ("getScmReleaseCommitComment".equals(this.descriptorCommentGetter)) {
            comment = releaseDescriptor.getScmReleaseCommitComment();
        } else if ("getScmDevelopmentCommitComment".equals(this.descriptorCommentGetter)) {
            comment = releaseDescriptor.getScmDevelopmentCommitComment();
        } else if ("getScmBranchCommitComment".equals(this.descriptorCommentGetter)) {
            comment = releaseDescriptor.getScmBranchCommitComment();
            branch = true;
        } else if ("getScmRollbackCommitComment".equals(this.descriptorCommentGetter)) {
            comment = releaseDescriptor.getScmRollbackCommitComment();
        } else {
            throw new ReleaseExecutionException("Invalid configuration of descriptorCommentGetter='" + this.descriptorCommentGetter + "'");
        }
        MavenProject project = ReleaseUtil.getRootProject(reactorProjects);
        comment = comment.replace("@{prefix}", releaseDescriptor.getScmCommentPrefix().trim());
        comment = comment.replace("@{groupId}", project.getGroupId());
        comment = comment.replace("@{artifactId}", project.getArtifactId());
        comment = branch ? comment.replace("@{branchName}", releaseDescriptor.getScmReleaseLabel()) : comment.replace("@{releaseLabel}", releaseDescriptor.getScmReleaseLabel());
        return comment;
    }

    protected static List<File> createPomFiles(ReleaseDescriptor releaseDescriptor, MavenProject project) {
        ArrayList<File> pomFiles = new ArrayList<File>();
        pomFiles.add(ReleaseUtil.getStandardPom(project));
        if (releaseDescriptor.isGenerateReleasePoms() && !releaseDescriptor.isSuppressCommitBeforeTagOrBranch()) {
            pomFiles.add(ReleaseUtil.getReleasePom(project));
        }
        return pomFiles;
    }

    protected List<File> createPomFiles(ReleaseDescriptor releaseDescriptor, List<MavenProject> reactorProjects) {
        ArrayList<File> pomFiles = new ArrayList<File>();
        for (MavenProject project : reactorProjects) {
            String path = project.getFile().getPath();
            boolean isExcludedPathFound = this.exclusionPatterns.stream().anyMatch(exclusionPattern -> FileSystems.getDefault().getPathMatcher("glob:" + exclusionPattern).matches(Paths.get(path, new String[0])));
            if (isExcludedPathFound) continue;
            pomFiles.addAll(AbstractScmCommitPhase.createPomFiles(releaseDescriptor, project));
        }
        return pomFiles;
    }
}

