/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class ReleaseUtil {
    public static final String RELEASE_POMv4 = "release-pom.xml";
    private static final String POMv4 = "pom.xml";
    public static final String LS = System.getProperty("line.separator");

    private ReleaseUtil() {
    }

    public static MavenProject getRootProject(List reactorProjects) {
        MavenProject project = (MavenProject)reactorProjects.get(0);
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject currentProject = (MavenProject)i.next();
            if (!currentProject.isExecutionRoot()) continue;
            project = currentProject;
            break;
        }
        return project;
    }

    public static File getStandardPom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        File releasePom = ReleaseUtil.getReleasePom(project);
        if (pom.equals(releasePom)) {
            pom = new File(pom.getParent(), POMv4);
        }
        return pom;
    }

    public static File getReleasePom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        return new File(pom.getParent(), RELEASE_POMv4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readXmlFile(File file) throws IOException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)file);
            String string = ReleaseUtil.normalizeLineEndings(IOUtil.toString((Reader)reader), LS);
            return string;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public static String normalizeLineEndings(String text, String separator) {
        String norm = text;
        if (text != null) {
            norm = text.replaceAll("(\r\n)|(\n)|(\r)", separator);
        }
        return norm;
    }
}

