/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.war.util;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.plexus.util.DirectoryScanner;

public class PathSet
implements Iterable<String> {
    private static final String SEPARATOR = "/";
    private static final char SEPARATOR_CHAR = "/".charAt(0);
    private Set<String> pathsSet = new LinkedHashSet<String>();

    static String normalizeSubPath(String path) {
        if (path.isEmpty()) {
            return path;
        }
        String cleanPath = path.replaceAll("[\\\\]+", SEPARATOR).replaceAll("[/]+", SEPARATOR);
        String string = cleanPath = cleanPath.charAt(0) == SEPARATOR_CHAR ? cleanPath.substring(1) : cleanPath;
        if (cleanPath.isEmpty()) {
            return cleanPath;
        }
        if (cleanPath.charAt(cleanPath.length() - 1) == SEPARATOR_CHAR) {
            return cleanPath.substring(0, cleanPath.length() - 1);
        }
        return cleanPath;
    }

    public PathSet() {
    }

    public PathSet(Collection<String> paths) {
        this.addAll(paths);
    }

    public PathSet(String[] paths) {
        this.addAll(paths);
    }

    public void add(String path) {
        this.pathsSet.add(PathSet.normalizeSubPath(path));
    }

    public void addAll(Collection<String> paths, String prefix) {
        for (String val : paths) {
            this.add(prefix + SEPARATOR + val);
        }
    }

    public void addAll(String[] paths, String prefix) {
        for (String val : paths) {
            this.add(prefix + SEPARATOR + val);
        }
    }

    public void addAll(PathSet paths, String prefix) {
        for (String path : paths) {
            this.add(prefix + SEPARATOR + path);
        }
    }

    public void addAll(Collection<String> paths) {
        this.addAll(paths, "");
    }

    public void addAll(String[] paths) {
        this.addAll(paths, "");
    }

    public void addAll(PathSet paths) {
        this.addAll(paths, "");
    }

    public boolean contains(String path) {
        return this.pathsSet.contains(PathSet.normalizeSubPath(path));
    }

    boolean remove(String path) {
        return this.pathsSet.remove(PathSet.normalizeSubPath(path));
    }

    @Override
    public Iterator<String> iterator() {
        return this.pathsSet.iterator();
    }

    public Collection<String> paths() {
        return this.pathsSet;
    }

    public void addPrefix(String prefix) {
        HashSet<String> newSet = new HashSet<String>();
        for (String path : this.pathsSet) {
            newSet.add(PathSet.normalizeSubPath(prefix + path));
        }
        this.pathsSet = newSet;
    }

    public int size() {
        return this.pathsSet.size();
    }

    public void addAllFilesInDirectory(File directory, String prefix) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.scan();
        this.addAll(scanner.getIncludedFiles(), prefix);
    }
}

