/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.verifier;

import java.util.Iterator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.verifier.VerificationResult;
import org.apache.maven.plugin.verifier.VerificationResultPrinter;
import org.apache.maven.plugin.verifier.model.File;

public class ConsoleVerificationResultPrinter
implements VerificationResultPrinter {
    private Log log;

    public ConsoleVerificationResultPrinter(Log log) {
        this.log = log;
    }

    public void print(VerificationResult results) {
        this.printExistenceFailures(results);
        this.printNonExistenceFailures(results);
        this.printContentFailures(results);
    }

    private void printExistenceFailures(VerificationResult results) {
        Iterator i = results.getExistenceFailures().iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            this.printMessage("File not found [" + file.getLocation() + "]");
        }
    }

    private void printNonExistenceFailures(VerificationResult results) {
        Iterator i = results.getNonExistenceFailures().iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            this.printMessage("File should not exist [" + file.getLocation() + "]");
        }
    }

    private void printContentFailures(VerificationResult results) {
        Iterator i = results.getContentFailures().iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            this.printMessage("File [" + file.getLocation() + "] does not match regexp [" + file.getContains() + "]");
        }
    }

    private void printMessage(String message) {
        this.log.error((CharSequence)("[Verifier] " + message));
    }
}

