/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.surefire.report.AbstractSurefireReportMojo;
import org.apache.maven.plugins.surefire.report.LocalizedProperties;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;

@Mojo(name="failsafe-report-only")
public class FailsafeReportMojo
extends AbstractSurefireReportMojo {
    @Parameter(defaultValue="failsafe-report", property="outputName", required=true)
    private String outputName;
    @Parameter(defaultValue="false", property="alwaysGenerateFailsafeReport")
    private boolean alwaysGenerateFailsafeReport;
    @Parameter(defaultValue="false", property="skipFailsafeReport")
    private boolean skipFailsafeReport;
    @Parameter(defaultValue="", property="failsafe.report.title")
    private String title;
    @Parameter(defaultValue="", property="failsafe.report.description")
    private String description;

    @Override
    protected File getSurefireReportsDirectory(MavenProject subProject) {
        String buildDir = subProject.getBuild().getDirectory();
        return new File(buildDir + "/failsafe-reports");
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    protected LocalizedProperties getBundle(Locale locale, ClassLoader resourceBundleClassLoader) {
        ResourceBundle bundle = ResourceBundle.getBundle("surefire-report", locale, resourceBundleClassLoader);
        return new LocalizedProperties(bundle){

            @Override
            public String getReportName() {
                return StringUtils.isEmpty((String)FailsafeReportMojo.this.getTitle()) ? this.toLocalizedValue("report.failsafe.name") : FailsafeReportMojo.this.getTitle();
            }

            @Override
            public String getReportDescription() {
                return StringUtils.isEmpty((String)FailsafeReportMojo.this.getDescription()) ? this.toLocalizedValue("report.failsafe.description") : FailsafeReportMojo.this.getDescription();
            }

            @Override
            public String getReportHeader() {
                return StringUtils.isEmpty((String)FailsafeReportMojo.this.getTitle()) ? this.toLocalizedValue("report.failsafe.header") : FailsafeReportMojo.this.getTitle();
            }
        };
    }

    @Override
    protected boolean isSkipped() {
        return this.skipFailsafeReport;
    }

    @Override
    protected boolean isGeneratedWhenNoResults() {
        return this.alwaysGenerateFailsafeReport;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

