/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugins.surefire.report.SurefireReportGenerator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class SurefireReportMojo
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    private boolean showSuccess;
    private File reportsDirectory;
    private String outputName;
    private File xrefLocation;
    private boolean linkXRef;

    public void executeReport(Locale locale) throws MavenReportException {
        SurefireReportGenerator report = new SurefireReportGenerator(this.reportsDirectory, locale, this.showSuccess, this.determineXrefLocation());
        report.doGenerateReport(this.getBundle(locale), this.getSink());
    }

    private String determineXrefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory, (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                Iterator reports = this.project.getReportPlugins().iterator();
                while (reports.hasNext()) {
                    ReportPlugin report = (ReportPlugin)reports.next();
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Test Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.description");
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return this.outputName;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("surefire-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean canGenerateReport() {
        try {
            if (this.reportsDirectory.exists() && this.reportsDirectory.isDirectory()) {
                List fileList = FileUtils.getFileNames((File)this.reportsDirectory, (String)"**/TEST-*.xml", (String)"", (boolean)true);
                return !fileList.isEmpty();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error accessing reports directory!");
        }
        return false;
    }
}

