/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.surefire.report.AbstractSurefireReportMojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="failsafe-report-only")
public class FailsafeReportMojo
extends AbstractSurefireReportMojo {
    @Parameter(defaultValue="failsafe-report", property="outputName", required=true)
    private String outputName;
    @Parameter(defaultValue="false", property="alwaysGenerateFailsafeReport")
    private boolean alwaysGenerateFailsafeReport;
    @Parameter(defaultValue="false", property="skipFailsafeReport")
    private boolean skipFailsafeReport;

    protected File getSurefireReportsDirectory(MavenProject subProject) {
        String buildDir = subProject.getBuild().getDirectory();
        return new File(buildDir + "/failsafe-reports");
    }

    public String getOutputName() {
        return this.outputName;
    }

    protected boolean isSkipped() {
        return this.skipFailsafeReport;
    }

    protected boolean isGeneratedWhenNoResults() {
        return this.alwaysGenerateFailsafeReport;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.failsafe.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.failsafe.description");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("surefire-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

