/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.SurefireBooter;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;

public class SurefirePlugin
extends AbstractSurefireMojo
implements SurefireExecutionParameters,
SurefireReportParameters {
    private boolean skipTests;
    private boolean skipExec;
    private boolean skip;
    private boolean testFailureIgnore;
    private File basedir;
    private File testClassesDirectory;
    private File classesDirectory;
    private MavenProject project;
    private List classpathDependencyExcludes;
    private String classpathDependencyScopeExclude;
    private List additionalClasspathElements;
    private File reportsDirectory;
    private File testSourceDirectory;
    private String test;
    private List includes;
    private List excludes;
    private ArtifactRepository localRepository;
    private Properties systemProperties;
    private Map systemPropertyVariables;
    private Properties properties;
    private Map pluginArtifactMap;
    private Map projectArtifactMap;
    private boolean printSummary;
    private String reportFormat;
    private boolean useFile;
    private boolean redirectTestOutputToFile;
    private Boolean failIfNoTests;
    private String forkMode;
    private String jvm;
    private String argLine;
    private String debugForkedProcess;
    private int forkedProcessTimeoutInSeconds;
    private Map environmentVariables = new HashMap();
    private File workingDirectory;
    private boolean childDelegation;
    private String groups;
    private String excludedGroups;
    private File[] suiteXmlFiles;
    private String junitArtifactName;
    private String testNGArtifactName;
    private int threadCount;
    private String perCoreThreadCount;
    private String useUnlimitedThreads;
    private String parallel;
    private boolean trimStackTrace;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private List remoteRepositories;
    private ArtifactMetadataSource metadataSource;
    private Properties originalSystemProperties;
    private Properties internalSystemProperties = new Properties();
    private boolean disableXmlReport;
    private Boolean useSystemClassLoader;
    private boolean useManifestOnlyJar;
    private boolean enableAssertions;
    private MavenSession session;
    private String objectFactory;
    private List includedAnnotations;
    private List excludedAnnotations;
    private Boolean parallelMavenExecution;
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.verifyParameters()) {
            int result;
            SurefireBooter surefireBooter = this.constructSurefireBooter();
            this.getLog().info((CharSequence)(StringUtils.capitalizeFirstLetter((String)this.getPluginName()) + " report directory: " + this.getReportsDirectory()));
            try {
                result = surefireBooter.run();
            }
            catch (SurefireBooterForkException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (SurefireExecutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (this.getOriginalSystemProperties() != null && !surefireBooter.isForking()) {
                System.setProperties(this.getOriginalSystemProperties());
            }
            SurefireHelper.reportExecution((SurefireReportParameters)this, (int)result, (Log)this.getLog());
        }
    }

    protected boolean verifyParameters() throws MojoFailureException {
        if (this.isSkip() || this.isSkipTests() || this.isSkipExec()) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.getTestClassesDirectory().exists()) {
            if (this.getFailIfNoTests() != null && this.getFailIfNoTests().booleanValue()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
            return true;
        }
        this.ensureWorkingDirectoryExists();
        this.ensureParallelRunningCompatibility();
        this.warnIfUselessUseSystemClassLoaderParameter();
        return true;
    }

    protected String getPluginName() {
        return "surefire";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/Test*.java", "**/*Test.java", "**/*TestCase.java"};
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipExec() {
        return this.skipExec;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List getClasspathDependencyExcludes() {
        return this.classpathDependencyExcludes;
    }

    public void setClasspathDependencyExcludes(List classpathDependencyExcludes) {
        this.classpathDependencyExcludes = classpathDependencyExcludes;
    }

    public String getClasspathDependencyScopeExclude() {
        return this.classpathDependencyScopeExclude;
    }

    public void setClasspathDependencyScopeExclude(String classpathDependencyScopeExclude) {
        this.classpathDependencyScopeExclude = classpathDependencyScopeExclude;
    }

    public List getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }

    public void setAdditionalClasspathElements(List additionalClasspathElements) {
        this.additionalClasspathElements = additionalClasspathElements;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public List getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List excludes) {
        this.excludes = excludes;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map getSystemPropertyVariables() {
        return this.systemPropertyVariables;
    }

    public void setSystemPropertyVariables(Map systemPropertyVariables) {
        this.systemPropertyVariables = systemPropertyVariables;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public void setPluginArtifactMap(Map pluginArtifactMap) {
        this.pluginArtifactMap = pluginArtifactMap;
    }

    public Map getProjectArtifactMap() {
        return this.projectArtifactMap;
    }

    public void setProjectArtifactMap(Map projectArtifactMap) {
        this.projectArtifactMap = projectArtifactMap;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(Boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public String getForkMode() {
        return this.forkMode;
    }

    public void setForkMode(String forkMode) {
        this.forkMode = forkMode;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public String getArgLine() {
        return this.argLine;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public Map getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isChildDelegation() {
        return this.childDelegation;
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(String excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public File[] getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = suiteXmlFiles;
    }

    public String getJunitArtifactName() {
        return this.junitArtifactName;
    }

    public void setJunitArtifactName(String junitArtifactName) {
        this.junitArtifactName = junitArtifactName;
    }

    public String getTestNGArtifactName() {
        return this.testNGArtifactName;
    }

    public void setTestNGArtifactName(String testNGArtifactName) {
        this.testNGArtifactName = testNGArtifactName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public String getPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public void setPerCoreThreadCount(String perCoreThreadCount) {
        this.perCoreThreadCount = perCoreThreadCount;
    }

    public String getUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public void setUseUnlimitedThreads(String useUnlimitedThreads) {
        this.useUnlimitedThreads = useUnlimitedThreads;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public void setTrimStackTrace(boolean trimStackTrace) {
        this.trimStackTrace = trimStackTrace;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public ArtifactMetadataSource getMetadataSource() {
        return this.metadataSource;
    }

    public void setMetadataSource(ArtifactMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
    }

    public Properties getOriginalSystemProperties() {
        return this.originalSystemProperties;
    }

    public void setOriginalSystemProperties(Properties originalSystemProperties) {
        this.originalSystemProperties = originalSystemProperties;
    }

    public Properties getInternalSystemProperties() {
        return this.internalSystemProperties;
    }

    public void setInternalSystemProperties(Properties internalSystemProperties) {
        this.internalSystemProperties = internalSystemProperties;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public void setDisableXmlReport(boolean disableXmlReport) {
        this.disableXmlReport = disableXmlReport;
    }

    public Boolean getUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    public void setUseSystemClassLoader(Boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public void setToolchainManager(ToolchainManager toolchainManager) {
        this.toolchainManager = toolchainManager;
    }

    public boolean isMavenParallel() {
        return this.parallelMavenExecution != null && this.parallelMavenExecution != false;
    }

    public List getExcludedAnnotations() {
        return this.excludedAnnotations;
    }

    public List getIncludedAnnotations() {
        return this.includedAnnotations;
    }

    public void setIncludedAnnotations(List includedAnnotations) {
        this.includedAnnotations = includedAnnotations;
    }

    public void setExcludedAnnotations(List excludedAnnotations) {
        this.excludedAnnotations = excludedAnnotations;
    }
}

