/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-surefire-plugin:2.6-MULE-4", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Surefire Plugin", 0);
        this.append(sb, "Surefire is a test framework project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "surefire:help", 0);
            this.append(sb, "Display help information on maven-surefire-plugin.\nCall\n\u00a0\u00a0mvn\u00a0surefire:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test".equals(this.goal)) {
            this.append(sb, "surefire:test", 0);
            this.append(sb, "Run tests using Surefire.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalClasspathElements", 2);
                this.append(sb, "Additional elements to be appended to the classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "argLine", 2);
                this.append(sb, "Arbitrary JVM options to set on the command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir (Default: ${basedir})", 2);
                this.append(sb, "The base directory of the project being tested. This can be obtained in your unit test by System.getProperty('basedir').", 3);
                this.append(sb, "", 0);
                this.append(sb, "childDelegation (Default: false)", 2);
                this.append(sb, "When false it makes tests run using the standard classloader delegation instead of the default Maven isolated classloader. Only used when forking (forkMode is not 'none').\nSetting it to false helps with some problems caused by conflicts between xml parsers in the classpath and the Java 5 provider parser.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The directory containing generated classes of the project being tested. This will be included after the test classes in the test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathDependencyExcludes", 2);
                this.append(sb, "List of dependencies to exclude from the test classpath. Each dependency string must follow the format groupId:artifactId. For example: org.acme:project-a", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathDependencyScopeExclude", 2);
                this.append(sb, "A dependency scope to exclude from the test classpath The scope can be one of the following scopes:\n-\tcompile - system, provided, compile\n-\truntime - compile, runtime\n-\ttest - system, provided, compile, runtime, test\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "debugForkedProcess", 2);
                this.append(sb, "Attach a debugger to the forked JVM. If set to 'true', the process will suspend and wait for a debugger to attach on port 5005. If set to some other string, that string will be appended to the argLine, allowing you to configure arbitrary debuggability options (without overwriting the other options specified in the argLine).", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableXmlReport (Default: false)", 2);
                this.append(sb, "Flag to disable the generation of report files in xml format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableAssertions (Default: true)", 2);
                this.append(sb, "By default, Surefire enables JVM assertions for the execution of your test cases. To disable the assertions, set this flag to false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentVariables", 2);
                this.append(sb, "Additional environments to set on the command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedAnnotations", 2);
                this.append(sb, "List of annotations to be used to filter out tests. If defined, only tests that don't have these annotations will be executed", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "(TestNG only) Excluded groups. Any methods/classes/etc with one of the groups specified in this list will specifically not be run. This parameter is overridden if suiteXmlFiles are specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of patterns (separated by commas) used to specify the tests that should be excluded in testing. When not specified and when the test parameter is not specified, the default excludes will be **/*$* (which excludes all inner classes). This parameter is ignored if TestNG suiteXmlFiles are specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfNoTests", 2);
                this.append(sb, "Set this to 'true' to cause a failure if there are no tests to run.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forkedProcessTimeoutInSeconds", 2);
                this.append(sb, "Kill the forked test process after a certain number of seconds. If set to 0, wait forever for the process, never timing out.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forkMode (Default: once)", 2);
                this.append(sb, "Option to specify the forking mode. Can be 'never', 'once' or 'always'. 'none' and 'pertest' are also accepted for backwards compatibility.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groups", 2);
                this.append(sb, "(TestNG only) Groups for this test. Only classes/methods/etc decorated with one of the groups specified here will be included in test run, if specified. This parameter is overridden if suiteXmlFiles are specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedAnnotations", 2);
                this.append(sb, "List of annotations to be used to filter tests. If defined, only tests that have these annotations will be executed", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of patterns (separated by commas) used to specify the tests that should be included in testing. When not specified and when the test parameter is not specified, the default includes will be **/Test*.java **/*Test.java **/*TestCase.java. This parameter is ignored if TestNG suiteXmlFiles are specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "junitArtifactName (Default: junit:junit)", 2);
                this.append(sb, "Allows you to specify the name of the JUnit artifact. If not set, junit:junit will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvm", 2);
                this.append(sb, "Option to specify the jvm (or path to the java executable) to use with the forking options. For the default, the jvm will be the same as the one used to run Maven.", 3);
                this.append(sb, "", 0);
                this.append(sb, "objectFactory", 2);
                this.append(sb, "(TestNG only) Define the factory class used to create all test instances", 3);
                this.append(sb, "", 0);
                this.append(sb, "parallel", 2);
                this.append(sb, "(TestNG only) When you use the parallel attribute, TestNG will try to run all your test methods in separate threads, except for methods that depend on each other, which will be run in the same thread in order to respect their order of execution.\n(JUnit 4.7 provider) Supports values classes\nmethods/both to run in separate threads, as controlled by threadCount.", 3);
                this.append(sb, "", 0);
                this.append(sb, "parallelMavenExecution (Default: ${session.parallel})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "perCoreThreadCount", 2);
                this.append(sb, "(JUnit 4.7 provider) Indicates that threadCount is per cpu core. Defaults to true", 3);
                this.append(sb, "", 0);
                this.append(sb, "printSummary (Default: true)", 2);
                this.append(sb, "Option to print summary of test suites or just print the test cases that has errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "List of properties for configuring all TestNG related configurations. This is the new preferred method of configuring TestNG.", 3);
                this.append(sb, "", 0);
                this.append(sb, "redirectTestOutputToFile (Default: false)", 2);
                this.append(sb, "When forking, set this to true to redirect the unit test standard output to a file (found in reportsDirectory/testName-output.txt).", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The plugin remote repositories declared in the POM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportFormat (Default: brief)", 2);
                this.append(sb, "Selects the formatting for the test report to be generated. Can be set as brief or plain.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/surefire-reports)", 2);
                this.append(sb, "Base directory where all reports are written to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass unit tests entirely. Its use is NOT RECOMMENDED, especially if you enable it using the 'maven.test.skip' property, because maven.test.skip disables both running the tests and compiling the tests. Consider using the skipTests parameter instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipExec", 2);
                this.append(sb, "Deprecated. Use -DskipTests instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "This old parameter is just like skipTests, but bound to the old property maven.test.skip.exec.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTests (Default: false)", 2);
                this.append(sb, "Set this to 'true' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "", 0);
                this.append(sb, "suiteXmlFiles", 2);
                this.append(sb, "(TestNG only) List of TestNG suite xml file locations, seperated by commas. Note that suiteXmlFiles is incompatible with several other parameters on this plugin, like includes/excludes. This parameter is ignored if the 'test' parameter is specified (allowing you to run a single test instead of an entire suite).", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "Deprecated. Use systemPropertyVariables instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemPropertyVariables", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "test", 2);
                this.append(sb, "Specify this parameter to run individual tests by file name, overriding the includes/excludes parameters. Each pattern you specify here will be used to create an include pattern formatted like **/${test}.java, so you can just type '-Dtest=MyTest' to run a single test called 'foo/MyTest.java'. This parameter will override the TestNG suiteXmlFiles parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "The directory containing generated test classes of the project being tested. This will be included at the beginning the test classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testFailureIgnore (Default: false)", 2);
                this.append(sb, "Set this to true to ignore a failure during testing. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testNGArtifactName (Default: org.testng:testng)", 2);
                this.append(sb, "Allows you to specify the name of the TestNG artifact. If not set, org.testng:testng will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceDirectory (Default: ${project.build.testSourceDirectory})", 2);
                this.append(sb, "The test source directory containing test class sources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "threadCount", 2);
                this.append(sb, "(TestNG/JUnit 4.7 provider only) The attribute thread-count allows you to specify how many threads should be allocated for this execution. Only makes sense to use in conjunction with parallel.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trimStackTrace (Default: true)", 2);
                this.append(sb, "Whether to trim the stack trace in the reports to just the lines within the test, or show the full trace.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useFile (Default: true)", 2);
                this.append(sb, "Option to generate a file test report or just output the test report to the console.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useManifestOnlyJar (Default: true)", 2);
                this.append(sb, "By default, Surefire forks your tests using a manifest-only JAR; set this parameter to 'false' to force it to launch your tests with a plain old Java classpath. (See http://maven.apache.org/plugins/maven-surefire-plugin/examples/class-loading.html for a more detailed explanation of manifest-only JARs and their benefits.)\nBeware, setting this to 'false' may cause your tests to fail on Windows if your classpath is too long.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSystemClassLoader", 2);
                this.append(sb, "Option to pass dependencies to the system's classloader instead of using an isolated class loader when forking. Prevents problems with JDKs which implement the service provider lookup mechanism by using the system's classloader. Default value is 'true'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useUnlimitedThreads", 2);
                this.append(sb, "(JUnit 4.7 provider) Indicates that the thread pool will be unlimited. The parallel parameter and the actual number of classes/methods will decide. Setting this to true effectively disables perCoreThreadCount and threadCount.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Command line working directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

