/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.run;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DoxiaDocumentRenderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugins.site.render.ReportDocumentRenderer;
import org.apache.maven.plugins.site.run.DoxiaBean;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.eclipse.jetty.http.MimeTypes;

public class DoxiaFilter
implements Filter {
    public static final String OUTPUT_DIRECTORY_KEY = "outputDirectory";
    public static final String SITE_RENDERER_KEY = "siteRenderer";
    public static final String I18N_DOXIA_CONTEXTS_KEY = "i18nDoxiaContexts";
    public static final String LOCALES_LIST_KEY = "localesList";
    private ServletContext servletContext;
    private File outputDirectory;
    private SiteRenderer siteRenderer;
    private Map<String, DoxiaBean> i18nDoxiaContexts;
    private List<Locale> localesList;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.outputDirectory = (File)this.servletContext.getAttribute(OUTPUT_DIRECTORY_KEY);
        this.siteRenderer = (SiteRenderer)this.servletContext.getAttribute(SITE_RENDERER_KEY);
        this.i18nDoxiaContexts = (Map)this.servletContext.getAttribute(I18N_DOXIA_CONTEXTS_KEY);
        this.localesList = (List)this.servletContext.getAttribute(LOCALES_LIST_KEY);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        DoxiaBean doxiaBean;
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        String path = req.getServletPath();
        if (path.endsWith("/")) {
            path = path + "index.html";
        }
        path = path.substring(1);
        String localeWanted = "";
        for (Locale locale : this.localesList) {
            if (!path.startsWith(locale + "/")) continue;
            localeWanted = locale.toString();
            path = path.substring(localeWanted.length() + 1);
        }
        if (!localeWanted.equals(SiteTool.DEFAULT_LOCALE.toString())) {
            doxiaBean = this.i18nDoxiaContexts.get(localeWanted);
            if (doxiaBean == null) {
                throw new ServletException("No Doxia bean found for locale '" + localeWanted + "'");
            }
        } else {
            doxiaBean = this.i18nDoxiaContexts.get("default");
            if (doxiaBean == null) {
                throw new ServletException("No Doxia bean found for the default locale");
            }
        }
        SiteRenderingContext context = doxiaBean.getContext();
        Map<String, DocumentRenderer> documents = doxiaBean.getDocuments();
        SiteRenderingContext generatedSiteContext = doxiaBean.getGeneratedSiteContext();
        if (documents.containsKey(path)) {
            try {
                ReportDocumentRenderer reportDocumentRenderer;
                DocumentRenderer docRenderer = documents.get(path);
                this.logDocumentRenderer(path, localeWanted, docRenderer);
                String outputName = docRenderer.getOutputName();
                String contentType = MimeTypes.getDefaultMimeByExtension((String)outputName);
                if (contentType != null) {
                    servletResponse.setContentType(contentType);
                }
                docRenderer.renderDocument((Writer)servletResponse.getWriter(), this.siteRenderer, context);
                if (docRenderer instanceof ReportDocumentRenderer && (reportDocumentRenderer = (ReportDocumentRenderer)docRenderer).isExternalReport()) {
                    Path externalReportFile = this.outputDirectory.toPath().resolve(outputName);
                    servletResponse.reset();
                    if (contentType != null) {
                        servletResponse.setContentType(contentType);
                    }
                    Files.copy(externalReportFile, (OutputStream)servletResponse.getOutputStream());
                }
                return;
            }
            catch (RendererException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (generatedSiteContext != null) {
            try {
                Map locateDocuments = this.siteRenderer.locateDocumentFiles(generatedSiteContext, false);
                if (locateDocuments.containsKey(path)) {
                    DocumentRenderer docRenderer = (DocumentRenderer)locateDocuments.get(path);
                    this.logDocumentRenderer(path, localeWanted, docRenderer);
                    String outputName = docRenderer.getOutputName();
                    String contentType = MimeTypes.getDefaultMimeByExtension((String)outputName);
                    if (contentType != null) {
                        servletResponse.setContentType(contentType);
                    }
                    docRenderer.renderDocument((Writer)servletResponse.getWriter(), this.siteRenderer, generatedSiteContext);
                    return;
                }
            }
            catch (RendererException e) {
                throw new ServletException((Throwable)e);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void logDocumentRenderer(String path, String locale, DocumentRenderer docRenderer) {
        String source;
        if (docRenderer instanceof DoxiaDocumentRenderer) {
            DoxiaDocumentRenderer doxiaDocumentRenderer = (DoxiaDocumentRenderer)docRenderer;
            source = doxiaDocumentRenderer.getRenderingContext().getInputName();
        } else if (docRenderer instanceof ReportDocumentRenderer) {
            ReportDocumentRenderer reportDocumentRenderer = (ReportDocumentRenderer)docRenderer;
            source = reportDocumentRenderer.getReportMojoInfo();
        } else {
            source = docRenderer.getClass().getName();
        }
        String localizedPath = !locale.equals(SiteTool.DEFAULT_LOCALE.toString()) ? locale + "/" + path : path;
        String localizedSource = source + (!locale.equals(SiteTool.DEFAULT_LOCALE.toString()) ? " (locale '" + locale + "')" : " (default locale)");
        this.servletContext.log(localizedPath + " -> " + MessageUtils.buffer().strong((Object)localizedSource));
    }

    public void destroy() {
    }
}

