/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.module.xdoc.XdocSinkFactory;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.Menu;
import org.apache.maven.doxia.site.MenuItem;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.tools.SiteTool;
import org.codehaus.plexus.i18n.I18N;

public class SiteMap {
    private String encoding;
    private I18N i18n;

    public SiteMap(String encoding, I18N i18n) {
        this.encoding = encoding;
        this.i18n = i18n;
    }

    public I18N getI18n() {
        return this.i18n;
    }

    public void setI18n(I18N i18n) {
        this.i18n = i18n;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(SiteModel siteModel, File targetDir, Locale locale) throws IOException {
        File outputDir = !locale.equals(SiteTool.DEFAULT_LOCALE) ? new File(new File(targetDir, locale.toString()), "xdoc") : new File(targetDir, "xdoc");
        try (Sink sink = new XdocSinkFactory().createSink(outputDir, "sitemap.xml", this.encoding);){
            this.extract(siteModel, sink, locale);
        }
    }

    private void extract(SiteModel siteModel, Sink sink, Locale locale) {
        sink.head();
        sink.title();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.section.title"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.description"));
        sink.paragraph_();
        for (Menu menu : siteModel.getMenus()) {
            sink.section2();
            sink.sectionTitle2();
            sink.text(menu.getName());
            sink.sectionTitle2_();
            sink.horizontalRule();
            SiteMap.extractItems(menu.getItems(), sink);
            sink.section2_();
        }
        sink.section1_();
        sink.body_();
    }

    private static void extractItems(List<MenuItem> items, Sink sink) {
        if (items == null || items.isEmpty()) {
            return;
        }
        sink.list();
        for (MenuItem item : items) {
            sink.listItem();
            if (item.getHref() != null) {
                sink.link(SiteMap.relativePath(item.getHref()));
            }
            sink.text(item.getName());
            if (item.getHref() != null) {
                sink.link_();
            }
            SiteMap.extractItems(item.getItems(), sink);
            sink.listItem_();
        }
        sink.list_();
    }

    private static String relativePath(String href) {
        return href.startsWith("/") ? "." + href : href;
    }
}

