/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.run;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugins.site.render.ReportDocumentRenderer;
import org.apache.maven.plugins.site.run.DoxiaBean;

public class DoxiaFilter
implements Filter {
    public static final String SITE_RENDERER_KEY = "siteRenderer";
    public static final String I18N_DOXIA_CONTEXTS_KEY = "i18nDoxiaContexts";
    public static final String LOCALES_LIST_KEY = "localesList";
    private Renderer siteRenderer;
    private Map<String, DoxiaBean> i18nDoxiaContexts;
    private List<Locale> localesList;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.siteRenderer = (Renderer)servletContext.getAttribute(SITE_RENDERER_KEY);
        this.i18nDoxiaContexts = (Map)servletContext.getAttribute(I18N_DOXIA_CONTEXTS_KEY);
        this.localesList = (List)servletContext.getAttribute(LOCALES_LIST_KEY);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SiteRenderingContext generatedSiteContext;
        Map<String, DocumentRenderer> documents;
        SiteRenderingContext context;
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        String path = req.getServletPath();
        if (path.endsWith("/")) {
            path = path + "index.html";
        }
        path = path.substring(1);
        String localeWanted = null;
        for (Locale locale : this.localesList) {
            if (!path.startsWith(locale.getLanguage() + "/")) continue;
            localeWanted = locale.toString();
            path = path.substring(locale.getLanguage().length() + 1);
        }
        if (localeWanted == null) {
            DoxiaBean defaultDoxiaBean = this.i18nDoxiaContexts.get("default");
            if (defaultDoxiaBean == null) {
                throw new ServletException("No doxia bean found for the default locale");
            }
            context = defaultDoxiaBean.getContext();
            documents = defaultDoxiaBean.getDocuments();
            generatedSiteContext = defaultDoxiaBean.getGeneratedSiteContext();
        } else {
            DoxiaBean i18nDoxiaBean = this.i18nDoxiaContexts.get(localeWanted);
            if (i18nDoxiaBean == null) {
                throw new ServletException("No doxia bean found for the locale " + localeWanted);
            }
            context = i18nDoxiaBean.getContext();
            documents = i18nDoxiaBean.getDocuments();
            generatedSiteContext = i18nDoxiaBean.getGeneratedSiteContext();
        }
        if (documents.containsKey(path)) {
            try {
                ReportDocumentRenderer reportDocumentRenderer;
                DocumentRenderer renderer = documents.get(path);
                renderer.renderDocument((Writer)servletResponse.getWriter(), this.siteRenderer, context);
                if (renderer instanceof ReportDocumentRenderer && (reportDocumentRenderer = (ReportDocumentRenderer)renderer).isExternalReport()) {
                    try {
                        filterChain.doFilter(servletRequest, servletResponse);
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                return;
            }
            catch (RendererException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (generatedSiteContext != null) {
            try {
                Map locateDocuments = this.siteRenderer.locateDocumentFiles(generatedSiteContext);
                if (locateDocuments.containsKey(path)) {
                    DocumentRenderer renderer = (DocumentRenderer)locateDocuments.get(path);
                    renderer.renderDocument((Writer)servletResponse.getWriter(), this.siteRenderer, generatedSiteContext);
                    return;
                }
            }
            catch (RendererException e) {
                throw new ServletException((Throwable)e);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

