/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.descriptor.AbstractSiteDescriptorMojo;
import org.apache.maven.plugins.site.render.CategorySummaryDocumentRenderer;
import org.apache.maven.plugins.site.render.ReportDocumentRenderer;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.reporting.exec.MavenReportExecutor;
import org.apache.maven.reporting.exec.MavenReportExecutorRequest;
import org.apache.maven.reporting.exec.ReportPlugin;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSiteRenderingMojo
extends AbstractSiteDescriptorMojo
implements Contextualizable {
    @Parameter
    private Map<String, String> moduleExcludes;
    @Parameter(property="templateFile")
    private File templateFile;
    @Parameter
    private Map<String, Object> attributes;
    @Component
    protected Renderer siteRenderer;
    @Parameter(defaultValue="${reports}", required=true, readonly=true)
    protected List<MavenReport> reports;
    @Parameter(defaultValue="${basedir}/xdocs")
    private File xdocDirectory;
    @Parameter(alias="workingDirectory", defaultValue="${project.build.directory}/generated-site")
    protected File generatedSiteDirectory;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(readonly=true)
    private ReportPlugin[] reportPlugins;
    private PlexusContainer container;
    @Parameter(property="generateProjectInfo", defaultValue="true")
    private boolean generateProjectInfo;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String inputEncoding;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter
    private boolean saveProcessedContent;

    protected String getInputEncoding() {
        return StringUtils.isEmpty((String)this.inputEncoding) ? ReaderFactory.FILE_ENCODING : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected void checkInputEncoding() {
        if (StringUtils.isEmpty((String)this.inputEncoding)) {
            this.getLog().warn((CharSequence)("Input file encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
    }

    protected List<MavenReportExecution> getReports() throws MojoExecutionException {
        List<Object> allReports;
        if (AbstractSiteRenderingMojo.isMaven3OrMore()) {
            MavenReportExecutor mavenReportExecutor;
            MavenReportExecutorRequest mavenReportExecutorRequest = new MavenReportExecutorRequest();
            mavenReportExecutorRequest.setLocalRepository(this.localRepository);
            mavenReportExecutorRequest.setMavenSession(this.mavenSession);
            mavenReportExecutorRequest.setProject(this.project);
            mavenReportExecutorRequest.setReportPlugins(this.reportPlugins);
            try {
                mavenReportExecutor = (MavenReportExecutor)this.container.lookup(MavenReportExecutor.class.getName());
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("could not get MavenReportExecutor component", (Exception)((Object)e));
            }
            allReports = mavenReportExecutor.buildMavenReports(mavenReportExecutorRequest);
        } else {
            allReports = new ArrayList<MavenReportExecution>(this.reports.size());
            for (MavenReport report : this.reports) {
                allReports.add(new MavenReportExecution(report));
            }
        }
        ArrayList<MavenReportExecution> reportExecutions = new ArrayList<MavenReportExecution>(allReports.size());
        for (MavenReportExecution exec : allReports) {
            if (!exec.canGenerateReport()) continue;
            reportExecutions.add(exec);
        }
        return reportExecutions;
    }

    protected SiteRenderingContext createSiteRenderingContext(Locale locale) throws MojoExecutionException, IOException, MojoFailureException {
        SiteRenderingContext context;
        DecorationModel decorationModel = this.prepareDecorationModel(locale);
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if (this.attributes.get("project") == null) {
            this.attributes.put("project", this.project);
        }
        if (this.attributes.get("inputEncoding") == null) {
            this.attributes.put("inputEncoding", this.getInputEncoding());
        }
        if (this.attributes.get("outputEncoding") == null) {
            this.attributes.put("outputEncoding", this.getOutputEncoding());
        }
        for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
            this.attributes.put((String)entry.getKey(), entry.getValue());
        }
        if (this.templateFile != null) {
            this.getLog().info((CharSequence)("Rendering site with " + this.templateFile + " template file."));
            if (!this.templateFile.exists()) {
                throw new MojoFailureException("Template file '" + this.templateFile + "' does not exist");
            }
            context = this.siteRenderer.createContextForTemplate(this.templateFile, this.attributes, decorationModel, this.project.getName(), locale);
        } else {
            try {
                Artifact skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.repositories, decorationModel);
                this.getLog().info((CharSequence)("Rendering site with " + skinArtifact.getId() + " skin."));
                File skinFile = skinArtifact.getFile();
                context = this.siteRenderer.createContextForSkin(skinFile, this.attributes, decorationModel, this.project.getName(), locale);
            }
            catch (SiteToolException e) {
                throw new MojoExecutionException("SiteToolException while preparing skin: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (RendererException e) {
                throw new MojoExecutionException("RendererException while preparing context for skin: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (!locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "xdoc");
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "fml");
        } else {
            context.addSiteDirectory(this.siteDirectory);
            context.addModuleDirectory(this.xdocDirectory, "xdoc");
            context.addModuleDirectory(this.xdocDirectory, "fml");
        }
        if (this.moduleExcludes != null) {
            context.setModuleExcludes(this.moduleExcludes);
        }
        if (this.saveProcessedContent) {
            context.setProcessedContentOutput(new File(this.generatedSiteDirectory, "processed"));
        }
        return context;
    }

    protected Map<String, MavenReport> locateReports(List<MavenReportExecution> reports, Map<String, DocumentRenderer> documents, Locale locale) {
        ArrayList<MavenReportExecution> filtered = new ArrayList<MavenReportExecution>(reports);
        LinkedHashMap<String, MavenReport> reportsByOutputName = new LinkedHashMap<String, MavenReport>();
        for (MavenReportExecution mavenReportExecution : filtered) {
            MavenReport report = mavenReportExecution.getMavenReport();
            String outputName = report.getOutputName() + ".html";
            reportsByOutputName.put(report.getOutputName(), report);
            if (documents.containsKey(outputName)) {
                String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
                String reportMojoInfo = mavenReportExecution.getGoal() == null ? "" : " (" + mavenReportExecution.getPlugin().getArtifactId() + ':' + mavenReportExecution.getPlugin().getVersion() + ':' + mavenReportExecution.getGoal() + ')';
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report" + reportMojoInfo + ", file \"" + outputName + "\" already exists for the " + displayLanguage + " version."));
                reports.remove(mavenReportExecution);
                continue;
            }
            RenderingContext renderingContext = new RenderingContext(this.siteDirectory, outputName);
            ReportDocumentRenderer renderer = new ReportDocumentRenderer(mavenReportExecution, renderingContext, this.getLog());
            documents.put(outputName, renderer);
        }
        return reportsByOutputName;
    }

    protected Map<String, List<MavenReport>> categoriseReports(Collection<MavenReport> reports) {
        LinkedHashMap<String, List<MavenReport>> categories = new LinkedHashMap<String, List<MavenReport>>();
        for (MavenReport report : reports) {
            ArrayList<MavenReport> categoryReports = (ArrayList<MavenReport>)categories.get(report.getCategoryName());
            if (categoryReports == null) {
                categoryReports = new ArrayList<MavenReport>();
                categories.put(report.getCategoryName(), categoryReports);
            }
            categoryReports.add(report);
        }
        return categories;
    }

    protected Map<String, DocumentRenderer> locateDocuments(SiteRenderingContext context, List<MavenReportExecution> reports, Locale locale) throws IOException, RendererException {
        CategorySummaryDocumentRenderer renderer;
        String desc2;
        String desc1;
        String title;
        RenderingContext renderingContext;
        List<MavenReport> categoryReports;
        Map documents = this.siteRenderer.locateDocumentFiles(context);
        Map<String, MavenReport> reportsByOutputName = this.locateReports(reports, documents, locale);
        Map<String, List<MavenReport>> categories = this.categoriseReports(reportsByOutputName.values());
        this.siteTool.populateReportsMenu(context.getDecoration(), locale, categories);
        this.populateReportItems(context.getDecoration(), locale, reportsByOutputName);
        if (categories.containsKey("Project Info") && this.generateProjectInfo) {
            categoryReports = categories.get("Project Info");
            renderingContext = new RenderingContext(this.siteDirectory, "project-info.html");
            title = this.i18n.getString("site-plugin", locale, "report.information.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.information.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.information.description2"), this.i18n, categoryReports, this.getLog());
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        if (categories.containsKey("Project Reports")) {
            categoryReports = categories.get("Project Reports");
            renderingContext = new RenderingContext(this.siteDirectory, "project-reports.html");
            title = this.i18n.getString("site-plugin", locale, "report.project.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.project.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.project.description2"), this.i18n, categoryReports, this.getLog());
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        return documents;
    }

    protected void populateReportItems(DecorationModel decorationModel, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        for (Menu menu : decorationModel.getMenus()) {
            this.populateItemRefs(menu.getItems(), locale, reportsByOutputName);
        }
    }

    private void populateItemRefs(List<MenuItem> items, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        Iterator<MenuItem> i = items.iterator();
        while (i.hasNext()) {
            MenuItem item = i.next();
            if (item.getRef() != null) {
                MavenReport report = reportsByOutputName.get(item.getRef());
                if (report != null) {
                    if (item.getName() == null) {
                        item.setName(report.getName(locale));
                    }
                    if (item.getHref() == null || item.getHref().length() == 0) {
                        item.setHref(report.getOutputName() + ".html");
                    }
                } else {
                    this.getLog().warn((CharSequence)("Unrecognised reference: '" + item.getRef() + "'"));
                    i.remove();
                }
            }
            this.populateItemRefs(item.getItems(), locale, reportsByOutputName);
        }
    }
}

