/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.run;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.site.render.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.run.DoxiaBean;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST, requiresReports=true)
public class SiteRunMojo
extends AbstractSiteRenderingMojo {
    @Parameter(defaultValue="${project.build.directory}/site-webapp")
    private File tempWebappDirectory;
    @Parameter(property="host", defaultValue="localhost")
    private String host;
    @Parameter(property="port", defaultValue="8080")
    private int port;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkInputEncoding();
        Server server = new Server(InetSocketAddress.createUnresolved(this.host, this.port));
        server.setStopAtShutdown(true);
        WebAppContext webapp = this.createWebApplication();
        webapp.setServer(server);
        server.setHandler((Handler)webapp);
        try {
            server.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing Jetty", e);
        }
        this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"Started Jetty on ").strong((Object)server.getURI()).build());
        try {
            server.getThreadPool().join();
        }
        catch (InterruptedException e) {
            this.getLog().warn((CharSequence)"Jetty was interrupted", (Throwable)e);
        }
    }

    private WebAppContext createWebApplication() throws MojoExecutionException {
        File webXml = new File(this.tempWebappDirectory, "WEB-INF/web.xml");
        webXml.getParentFile().mkdirs();
        try (InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/run/web.xml");){
            FileOutputStream outStream = new FileOutputStream(webXml);
            Object object = null;
            try {
                IOUtil.copy((InputStream)inStream, (OutputStream)outStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (outStream != null) {
                    if (object != null) {
                        try {
                            outStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        outStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to construct temporary webapp for running site", (Exception)e);
        }
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setResourceBase(this.tempWebappDirectory.getAbsolutePath());
        webapp.setAttribute("outputDirectory", (Object)this.tempWebappDirectory);
        webapp.setAttribute("siteRenderer", (Object)this.siteRenderer);
        webapp.getInitParams().put("org.mortbay.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.project.getReporting().setOutputDirectory(this.tempWebappDirectory.getAbsolutePath());
        List<Locale> localesList = this.getLocales();
        webapp.setAttribute("localesList", localesList);
        try {
            HashMap<String, DoxiaBean> i18nDoxiaContexts = new HashMap<String, DoxiaBean>();
            for (Locale locale : localesList) {
                SiteRenderingContext i18nContext = this.createSiteRenderingContext(locale);
                i18nContext.setInputEncoding(this.getInputEncoding());
                i18nContext.setOutputEncoding(this.getOutputEncoding());
                File outputDirectory = this.getOutputDirectory(locale);
                List<MavenReportExecution> reports = this.getReports(outputDirectory);
                Map<String, DocumentRenderer> i18nDocuments = this.locateDocuments(i18nContext, reports, locale);
                DoxiaBean doxiaBean = new DoxiaBean(i18nContext, i18nDocuments);
                if (!locale.equals(SiteTool.DEFAULT_LOCALE)) {
                    i18nDoxiaContexts.put(locale.toString(), doxiaBean);
                } else {
                    i18nDoxiaContexts.put("default", doxiaBean);
                }
                if (!locale.equals(SiteTool.DEFAULT_LOCALE)) {
                    this.siteRenderer.copyResources(i18nContext, new File(this.tempWebappDirectory, locale.toString()));
                    continue;
                }
                this.siteRenderer.copyResources(i18nContext, this.tempWebappDirectory);
            }
            webapp.setAttribute("i18nDoxiaContexts", i18nDoxiaContexts);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to set up webapp", e);
        }
        return webapp;
    }

    private File getOutputDirectory(Locale locale) {
        File file = !locale.equals(SiteTool.DEFAULT_LOCALE) ? new File(this.tempWebappDirectory, locale.toString()) : this.tempWebappDirectory;
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public void setTempWebappDirectory(File tempWebappDirectory) {
        this.tempWebappDirectory = tempWebappDirectory;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

