/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.MojoLogWrapper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;

public class ReportDocumentRenderer
implements DocumentRenderer {
    private final MavenReport report;
    private final RenderingContext renderingContext;
    private final String reportMojoInfo;
    private final ClassLoader classLoader;
    private final Log log;

    public ReportDocumentRenderer(MavenReportExecution mavenReportExecution, RenderingContext renderingContext, Log log) {
        this.report = mavenReportExecution.getMavenReport();
        this.renderingContext = renderingContext;
        this.reportMojoInfo = mavenReportExecution.getPlugin().getArtifactId() + ':' + mavenReportExecution.getPlugin().getVersion() + ':' + mavenReportExecution.getGoal();
        this.classLoader = mavenReportExecution.getClassLoader();
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDocument(Writer writer, Renderer renderer, SiteRenderingContext siteRenderingContext) throws RendererException, FileNotFoundException {
        Locale locale = siteRenderingContext.getLocale();
        String localReportName = this.report.getName(locale);
        String msg = "Generating \"" + MessageUtils.buffer().strong((Object)localReportName) + "\" report";
        this.log.info((CharSequence)(this.reportMojoInfo == null ? msg + '.' : StringUtils.rightPad((String)msg, (int)40) + MessageUtils.buffer().strong((Object)" --- ").mojo((Object)this.reportMojoInfo)));
        SiteRendererSink mainSink = new SiteRendererSink(this.renderingContext);
        MultiPageSinkFactory multiPageSinkFactory = new MultiPageSinkFactory(this.report, this.renderingContext);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            if (this.report instanceof MavenMultiPageReport) {
                ((MavenMultiPageReport)this.report).generate((Sink)mainSink, (SinkFactory)multiPageSinkFactory, locale);
            } else if (this.generateMultiPage(locale, multiPageSinkFactory, (Sink)mainSink)) {
            } else {
                this.report.generate((Sink)mainSink, locale);
            }
        }
        catch (MavenReportException e) {
            String report = this.reportMojoInfo == null ? '\"' + localReportName + '\"' : this.reportMojoInfo;
            throw new RendererException("Error generating " + report + " report", (Throwable)e);
        }
        catch (RuntimeException re) {
            String report = this.reportMojoInfo == null ? '\"' + localReportName + '\"' : this.reportMojoInfo;
            throw new RendererException("Error generating " + report + " report", (Throwable)re);
        }
        catch (LinkageError e) {
            String report = this.reportMojoInfo == null ? '\"' + localReportName + '\"' : this.reportMojoInfo;
            this.log.warn((CharSequence)("An issue has occurred with " + report + " report, skipping LinkageError " + e.getMessage() + ", please report an issue to Maven dev team."), (Throwable)e);
        }
        finally {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            mainSink.close();
        }
        if (this.report.isExternalReport()) {
            return;
        }
        renderer.mergeDocumentIntoSite(writer, (DocumentContent)mainSink, siteRenderingContext);
        String outputName = "";
        try {
            List<MultiPageSubSink> sinks = multiPageSinkFactory.sinks();
            this.log.debug((CharSequence)("Multipage report: " + sinks.size() + " subreports"));
            for (MultiPageSubSink mySink : sinks) {
                mySink.enableLogging((org.apache.maven.doxia.logging.Log)new MojoLogWrapper(this.log));
                outputName = mySink.getOutputName();
                this.log.debug((CharSequence)("  Rendering " + outputName));
                if (!mySink.getOutputDir().exists()) {
                    mySink.getOutputDir().mkdirs();
                }
                File outputFile = new File(mySink.getOutputDir(), outputName);
                try {
                    Writer out = WriterFactory.newWriter((File)outputFile, (String)siteRenderingContext.getOutputEncoding());
                    Throwable throwable = null;
                    try {
                        renderer.mergeDocumentIntoSite(out, (DocumentContent)mySink, siteRenderingContext);
                        mySink.close();
                        mySink = null;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                finally {
                    if (mySink == null) continue;
                    mySink.close();
                }
            }
        }
        catch (IOException e) {
            throw new RendererException("Cannot create writer to " + outputName, (Throwable)e);
        }
    }

    private boolean generateMultiPage(Locale locale, SinkFactory sf, Sink sink) throws MavenReportException {
        try {
            Method generate = this.report.getClass().getMethod("generate", Sink.class, SinkFactory.class, Locale.class);
            generate.invoke((Object)this.report, sink, sf, locale);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ite) {
            throw new MavenReportException("error while invoking generate on " + this.report.getClass(), ite);
        }
    }

    public String getOutputName() {
        return this.renderingContext.getOutputName();
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    public boolean isOverwrite() {
        return true;
    }

    public boolean isExternalReport() {
        return this.report.isExternalReport();
    }

    public String getReportMojoInfo() {
        return this.reportMojoInfo;
    }

    private static class MultiPageSinkFactory
    implements SinkFactory {
        private MavenReport report;
        private RenderingContext context;
        private List<MultiPageSubSink> sinks = new ArrayList<MultiPageSubSink>();

        MultiPageSinkFactory(MavenReport report, RenderingContext context) {
            this.report = report;
            this.context = context;
        }

        public Sink createSink(File outputDir, String outputName) {
            String outputRelativeToTargetSite = PathTool.getRelativeFilePath((String)this.report.getReportOutputDirectory().getPath(), (String)new File(outputDir, outputName).getPath());
            RenderingContext subSinkContext = new RenderingContext(this.context.getBasedir(), this.context.getBasedirRelativePath(), outputRelativeToTargetSite, this.context.getParserId(), this.context.getExtension(), this.context.isEditable(), this.context.getGenerator());
            MultiPageSubSink sink = new MultiPageSubSink(outputDir, outputName, subSinkContext);
            this.sinks.add(sink);
            return sink;
        }

        public Sink createSink(File arg0, String arg1, String arg2) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0, String arg1) throws IOException {
            return null;
        }

        public List<MultiPageSubSink> sinks() {
            return this.sinks;
        }
    }

    private static class MultiPageSubSink
    extends SiteRendererSink {
        private File outputDir;
        private String outputName;

        MultiPageSubSink(File outputDir, String outputName, RenderingContext context) {
            super(context);
            this.outputName = outputName;
            this.outputDir = outputDir;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public File getOutputDir() {
            return this.outputDir;
        }
    }
}

