/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.plugins.site.CategorySummaryDocumentRenderer;
import org.apache.maven.plugins.site.ReportDocumentRenderer;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSiteRenderingMojo
extends AbstractSiteMojo {
    protected Map moduleExcludes;
    protected DecorationModelInheritanceAssembler assembler;
    protected ArtifactResolver artifactResolver;
    protected List repositories;
    protected ArtifactFactory artifactFactory;
    private File templateDirectory;
    private String template;
    private File templateFile;
    protected Map attributes;
    protected Renderer siteRenderer;
    protected List reports;
    private File xdocDirectory;
    protected File generatedSiteDirectory;

    protected List filterReports(List reports) {
        ArrayList<MavenReport> filteredReports = new ArrayList<MavenReport>(reports.size());
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            try {
                if (!report.canGenerateReport()) continue;
                filteredReports.add(report);
            }
            catch (AbstractMethodError e) {
                this.getLog().warn((CharSequence)("Error loading report " + report.getClass().getName() + " - AbstractMethodError: canGenerateReport()"));
                filteredReports.add(report);
            }
        }
        return filteredReports;
    }

    protected SiteRenderingContext createSiteRenderingContext(Locale locale) throws MojoExecutionException, IOException, MojoFailureException {
        SiteRenderingContext context;
        File skinFile;
        DecorationModel decorationModel;
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (this.attributes.get("project") == null) {
            this.attributes.put("project", this.project);
        }
        if (this.attributes.get("inputEncoding") == null) {
            this.attributes.put("inputEncoding", this.getInputEncoding());
        }
        if (this.attributes.get("outputEncoding") == null) {
            this.attributes.put("outputEncoding", this.getOutputEncoding());
        }
        this.attributes.putAll(this.project.getProperties());
        try {
            decorationModel = this.siteTool.getDecorationModel(this.project, this.reactorProjects, this.localRepository, this.repositories, AbstractSiteRenderingMojo.toRelative(this.project.getBasedir(), this.siteDirectory.getAbsolutePath()), locale, this.getInputEncoding(), this.getOutputEncoding());
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.template != null) {
            if (this.templateFile != null) {
                this.getLog().warn((CharSequence)"'template' configuration is ignored when 'templateFile' is set");
            } else {
                this.templateFile = new File(this.templateDirectory, this.template);
            }
        }
        try {
            skinFile = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.repositories, decorationModel).getFile();
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.templateFile != null) {
            if (!this.templateFile.exists()) {
                throw new MojoFailureException("Template file '" + this.templateFile + "' does not exist");
            }
            context = this.siteRenderer.createContextForTemplate(this.templateFile, skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        } else {
            context = this.siteRenderer.createContextForSkin(skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        }
        if (!locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "xdoc");
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "fml");
        } else {
            context.addSiteDirectory(this.siteDirectory);
            context.addModuleDirectory(this.xdocDirectory, "xdoc");
            context.addModuleDirectory(this.xdocDirectory, "fml");
        }
        if (this.moduleExcludes != null) {
            context.setModuleExcludes(this.moduleExcludes);
        }
        return context;
    }

    protected Map locateReports(List reports, Map documents, Locale locale) {
        HashMap<String, MavenReport> reportsByOutputName = new HashMap<String, MavenReport>();
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            String outputName = report.getOutputName() + ".html";
            reportsByOutputName.put(report.getOutputName(), report);
            if (documents.containsKey(outputName)) {
                String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report, file \"" + outputName + "\" already exists for the " + displayLanguage + " version."));
                i.remove();
                continue;
            }
            RenderingContext renderingContext = new RenderingContext(this.siteDirectory, outputName);
            ReportDocumentRenderer renderer = new ReportDocumentRenderer(report, renderingContext, this.getLog());
            documents.put(outputName, renderer);
        }
        return reportsByOutputName;
    }

    protected Map categoriseReports(Collection reports) {
        HashMap<String, ArrayList<MavenReport>> categories = new HashMap<String, ArrayList<MavenReport>>();
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            ArrayList<MavenReport> categoryReports = (ArrayList<MavenReport>)categories.get(report.getCategoryName());
            if (categoryReports == null) {
                categoryReports = new ArrayList<MavenReport>();
                categories.put(report.getCategoryName(), categoryReports);
            }
            categoryReports.add(report);
        }
        return categories;
    }

    protected Map locateDocuments(SiteRenderingContext context, List reports, Locale locale) throws IOException, RendererException {
        CategorySummaryDocumentRenderer renderer;
        String desc2;
        String desc1;
        String title;
        RenderingContext renderingContext;
        List categoryReports;
        HashMap documents = this.siteRenderer.locateDocumentFiles(context);
        HashMap tmp = new HashMap();
        Iterator it = documents.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            tmp.put(StringUtils.replace((String)key, (String)"\\", (String)"/"), documents.get(key));
        }
        documents = tmp;
        Map reportsByOutputName = this.locateReports(reports, documents, locale);
        Map categories = this.categoriseReports(reportsByOutputName.values());
        this.siteTool.populateReportsMenu(context.getDecoration(), locale, categories);
        this.populateReportItems(context.getDecoration(), locale, reportsByOutputName);
        if (categories.containsKey("Project Info")) {
            categoryReports = (List)categories.get("Project Info");
            renderingContext = new RenderingContext(this.siteDirectory, "project-info.html");
            title = this.i18n.getString("site-plugin", locale, "report.information.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.information.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.information.description2"), this.i18n, categoryReports);
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        if (categories.containsKey("Project Reports")) {
            categoryReports = (List)categories.get("Project Reports");
            renderingContext = new RenderingContext(this.siteDirectory, "project-reports.html");
            title = this.i18n.getString("site-plugin", locale, "report.project.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.project.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.project.description2"), this.i18n, categoryReports);
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        return documents;
    }
}

