/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class ComponentsXmlResourceTransformer
implements ResourceTransformer {
    private Map components = new LinkedHashMap();
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    public boolean canTransformResource(String resource) {
        return COMPONENTS_XML_PATH.equals(resource);
    }

    public void processResource(InputStream is) throws IOException {
        Xpp3Dom newDom;
        File f = File.createTempFile("maven-shade-plugin", "tmp");
        f.deleteOnExit();
        FileOutputStream os = new FileOutputStream(f);
        IOUtil.copy((InputStream)is, (OutputStream)os);
        ((OutputStream)os).close();
        try {
            XmlStreamReader reader = ReaderFactory.newXmlReader((File)f);
            newDom = Xpp3DomBuilder.build((Reader)reader);
        }
        catch (Exception e) {
            throw new IOException("Error parsing components.xml in " + is);
        }
        if (newDom.getChild("components") == null) {
            return;
        }
        Xpp3Dom[] children = newDom.getChild("components").getChildren("component");
        for (int i = 0; i < children.length; ++i) {
            Xpp3Dom component = children[i];
            String role = component.getChild("role").getValue();
            Xpp3Dom child = component.getChild("role-hint");
            String roleHint = child != null ? child.getValue() : "";
            this.components.put(role + roleHint, component);
        }
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)this.getTransformedResource());
        jos.putNextEntry(new JarEntry(COMPONENTS_XML_PATH));
        IOUtil.copy((Reader)reader, (OutputStream)jos);
        reader.close();
        this.components.clear();
    }

    public boolean hasTransformedResource() {
        return this.components.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getTransformedResource() throws IOException {
        File f = File.createTempFile("shade-maven-plugin-plx", "tmp");
        f.deleteOnExit();
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)f);
        try {
            Xpp3Dom dom = new Xpp3Dom("component-set");
            Xpp3Dom componentDom = new Xpp3Dom("components");
            dom.addChild(componentDom);
            Iterator i = this.components.values().iterator();
            while (i.hasNext()) {
                Xpp3Dom component = (Xpp3Dom)i.next();
                componentDom.addChild(component);
            }
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        return f;
    }
}

