/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scripting;

import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugins.scripting.AbstractScriptEvaluator;
import org.apache.maven.plugins.scripting.UnsupportedScriptEngineException;

public class StringScriptEvaluator
extends AbstractScriptEvaluator {
    private final String engineName;
    private final String script;

    public StringScriptEvaluator(String engineName, String script) {
        if (engineName == null || engineName.isEmpty()) {
            throw new IllegalArgumentException("Expected a non-empty engine name provided");
        }
        this.engineName = engineName;
        if (script == null || script.trim().isEmpty()) {
            throw new IllegalArgumentException("Expected a non-empty script provided");
        }
        this.script = script;
    }

    @Override
    protected ScriptEngine getEngine(ScriptEngineManager manager) throws UnsupportedScriptEngineException {
        ScriptEngine result = manager.getEngineByName(this.engineName);
        if (result == null) {
            throw new UnsupportedScriptEngineException("Unknown engine specified with name \"" + this.engineName + "\"");
        }
        return result;
    }

    @Override
    protected Object eval(ScriptEngine engine, ScriptContext context) throws ScriptException {
        return engine.eval(this.script, context);
    }
}

