/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scripting;

import java.io.File;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.scripting.AbstractScriptEvaluator;
import org.apache.maven.plugins.scripting.FileScriptEvaluator;
import org.apache.maven.plugins.scripting.StringScriptEvaluator;
import org.apache.maven.plugins.scripting.UnsupportedScriptEngineException;
import org.apache.maven.project.MavenProject;

@Mojo(name="eval")
public class EvalMojo
extends AbstractMojo {
    @Parameter
    private String engineName;
    @Parameter
    private String script;
    @Parameter
    private File scriptFile;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            AbstractScriptEvaluator execute = this.constructExecute();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("project", (Object)this.project);
            bindings.put("log", (Object)this.getLog());
            Object result = execute.eval(bindings);
            this.getLog().info((CharSequence)"Result:");
            if (result != null) {
                this.getLog().info((CharSequence)result.toString());
            }
        }
        catch (ScriptException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (UnsupportedScriptEngineException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private AbstractScriptEvaluator constructExecute() throws IllegalArgumentException {
        AbstractScriptEvaluator execute;
        if (this.scriptFile != null) {
            execute = new FileScriptEvaluator(this.engineName, this.scriptFile);
        } else if (this.script != null) {
            execute = new StringScriptEvaluator(this.engineName, this.script);
        } else {
            throw new IllegalArgumentException("Missing script or scriptFile provided");
        }
        return execute;
    }
}

