/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.plugin.CheckoutMojo;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="bootstrap", requiresProject=false)
public class BootstrapMojo
extends CheckoutMojo {
    @Parameter(property="goals")
    private String goals;
    @Parameter(property="profiles")
    private String profiles;
    @Parameter(property="goalsDirectory")
    private String goalsDirectory;
    @Parameter(property="mavenHome", defaultValue="${maven.home}")
    private File mavenHome;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getCheckoutResult() != null) {
            ScmResult checkoutResult = this.getCheckoutResult();
            String relativePathProjectDirectory = "";
            if (checkoutResult instanceof CheckOutScmResult) {
                relativePathProjectDirectory = ((CheckOutScmResult)checkoutResult).getRelativePathProjectDirectory();
            }
            this.runGoals(relativePathProjectDirectory);
        }
    }

    private void runGoals(String relativePathProjectDirectory) throws MojoExecutionException {
        Commandline cl = new Commandline();
        try {
            cl.addSystemEnvironment();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't add system environment variables to mvn command line.", e);
        }
        cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        if (this.mavenHome == null) {
            cl.setExecutable("mvn");
        } else {
            String mvnPath = this.mavenHome.getAbsolutePath() + "/bin/mvn";
            if (Os.isFamily((String)"windows")) {
                String winMvnPath = mvnPath + ".cmd";
                if (!new File(winMvnPath).exists()) {
                    winMvnPath = mvnPath + ".bat";
                }
                mvnPath = winMvnPath;
            }
            cl.setExecutable(mvnPath);
        }
        cl.setWorkingDirectory(this.determineWorkingDirectoryPath(this.getCheckoutDirectory(), relativePathProjectDirectory, this.goalsDirectory));
        if (this.goals != null) {
            String[] tokens = StringUtils.split((String)this.goals, (String)", ");
            for (int i = 0; i < tokens.length; ++i) {
                cl.createArg().setValue(tokens[i]);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.profiles)) {
            cl.createArg().setValue("-P" + this.profiles);
        }
        DefaultConsumer consumer = new DefaultConsumer();
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)consumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of mvn execution is: '" + result + "'. Release failed.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Can't run goal " + this.goals, (Exception)((Object)e));
        }
    }

    protected String determineWorkingDirectoryPath(File checkoutDirectory, String relativePathProjectDirectory, String goalsDirectory) {
        File projectDirectory = relativePathProjectDirectory != null && !relativePathProjectDirectory.isEmpty() ? new File(checkoutDirectory, relativePathProjectDirectory) : checkoutDirectory;
        if (goalsDirectory == null || goalsDirectory.isEmpty()) {
            return projectDirectory.getPath();
        }
        return new File(projectDirectory, goalsDirectory).getPath();
    }
}

