/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;

public class UpdateMojo
extends AbstractScmMojo {
    private String scmVersionType;
    private String scmVersion;
    private String revisionKey;
    private MavenProject project;
    private boolean runChangelog = false;

    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            UpdateScmResult result = this.getScmManager().update(repository, this.getFileSet(), this.getScmVersion(this.scmVersionType, this.scmVersion), this.runChangelog);
            this.checkResult((ScmResult)result);
            if (result instanceof UpdateScmResultWithRevision) {
                String revision = ((UpdateScmResultWithRevision)result).getRevision();
                this.getLog().info((CharSequence)("Storing revision in '" + this.revisionKey + "' project property."));
                if (this.project.getProperties() != null) {
                    this.project.getProperties().put(this.revisionKey, revision);
                }
                this.getLog().info((CharSequence)("Project at revision " + revision));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run update command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run update command : ", (Exception)((Object)e));
        }
    }
}

