/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.LifecyclePhase;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.plugins.resources.Resource;
import org.apache.maven.plugins.resources.ResourcesMojo;

@Mojo(name="testResources", defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES, requiresProject=true)
public class TestResourcesMojo
extends ResourcesMojo {
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private Path outputDirectory;
    @Parameter
    private List<Resource> resources;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not copying test resources");
            return;
        }
        if (this.resources == null) {
            this.resources = this.project.getBuild().getTestResources().stream().map(Resource::new).collect(Collectors.toList());
        }
        super.doExecute();
    }

    @Override
    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }
}

