/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Component;
import org.apache.maven.api.plugin.annotations.LifecyclePhase;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.plugins.resources.MavenBuildTimestamp;
import org.apache.maven.plugins.resources.Resource;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Mojo(name="resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true)
public class ResourcesMojo
implements org.apache.maven.api.plugin.Mojo,
Contextualizable {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    protected String propertiesEncoding;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private Path outputDirectory;
    @Parameter
    private List<Resource> resources;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected Project project;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    protected List<String> buildFilters;
    @Parameter
    protected List<String> filters;
    @Parameter(defaultValue="true")
    protected boolean useBuildFilters;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected Session session;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="false")
    private boolean overwrite;
    @Parameter(defaultValue="false")
    protected boolean includeEmptyDirs;
    @Parameter
    protected List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="true")
    protected boolean escapeWindowsPaths;
    @Parameter
    protected LinkedHashSet<String> delimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter(defaultValue="true")
    protected boolean addDefaultExcludes;
    @Parameter
    private List<String> mavenFilteringHints;
    private PlexusContainer plexusContainer;
    private List<MavenResourcesFiltering> mavenFilteringComponents = new ArrayList<MavenResourcesFiltering>();
    @Parameter(defaultValue="false")
    private boolean supportMultiLineFiltering;
    @Parameter(defaultValue="false")
    private boolean fileNameFiltering;
    @Parameter(property="maven.resources.skip", defaultValue="false")
    private boolean skip;
    @Inject
    private Log logger;

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    public void execute() throws MojoException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping the execution.");
            return;
        }
        if (this.resources == null) {
            this.resources = this.project.getBuild().getResources().stream().map(Resource::new).collect(Collectors.toList());
        }
        this.doExecute();
    }

    protected void doExecute() throws MojoException {
        if (StringUtils.isBlank((CharSequence)this.encoding) && this.isFilteringEnabled(this.getResources())) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + System.getProperty("file.encoding") + ". Build is platform dependent!"));
            this.getLog().warn((CharSequence)"See https://maven.apache.org/general.html#encoding-warning");
        }
        try {
            List<String> combinedFilters = this.getCombinedFiltersList();
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(this.getResources(), this.getOutputDirectory(), this.project, this.encoding, combinedFilters, Collections.emptyList(), this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            mavenResourcesExecution.setInjectProjectBuildFilters(false);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setOverwrite(this.overwrite);
            mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
            mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            mavenResourcesExecution.setFilterFilenames(this.fileNameFiltering);
            mavenResourcesExecution.setAddDefaultExcludes(this.addDefaultExcludes);
            Properties additionalProperties = this.addSeveralSpecialProperties();
            mavenResourcesExecution.setAdditionalProperties(additionalProperties);
            mavenResourcesExecution.setDelimiters(this.delimiters, this.useDefaultDelimiters);
            mavenResourcesExecution.setPropertiesEncoding(this.propertiesEncoding);
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
            this.executeUserFilterComponents(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoException(e.getMessage(), (Throwable)e);
        }
    }

    private Properties addSeveralSpecialProperties() {
        String timeStamp = new MavenBuildTimestamp().formattedTimestamp();
        Properties additionalProperties = new Properties();
        additionalProperties.put("maven.build.timestamp", timeStamp);
        if (this.project.getBasedir().isPresent()) {
            additionalProperties.put("project.baseUri", ((Path)this.project.getBasedir().get()).toAbsolutePath().toFile().toURI().toString());
        }
        return additionalProperties;
    }

    protected void executeUserFilterComponents(MavenResourcesExecution mavenResourcesExecution) throws MojoException, MavenFilteringException {
        if (this.mavenFilteringHints != null) {
            for (String hint : this.mavenFilteringHints) {
                try {
                    this.mavenFilteringComponents.add((MavenResourcesFiltering)this.plexusContainer.lookup(MavenResourcesFiltering.class.getName(), hint));
                }
                catch (ComponentLookupException e) {
                    throw new MojoException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            this.getLog().debug((CharSequence)"no use filter components");
        }
        if (this.mavenFilteringComponents != null && !this.mavenFilteringComponents.isEmpty()) {
            this.getLog().debug((CharSequence)"execute user filters");
            for (MavenResourcesFiltering filter : this.mavenFilteringComponents) {
                filter.filterResources(mavenResourcesExecution);
            }
        }
    }

    protected List<String> getCombinedFiltersList() {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.useBuildFilters ? this.buildFilters : null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.useBuildFilters && this.buildFilters != null && !this.buildFilters.isEmpty()) {
            result.addAll(this.buildFilters);
        }
        result.addAll(this.filters);
        return result;
    }

    private boolean isFilteringEnabled(Collection<Resource> theResources) {
        if (theResources != null) {
            for (Resource resource : theResources) {
                if (!resource.isFiltering()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public LinkedHashSet<String> getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(LinkedHashSet<String> delimiters) {
        this.delimiters = delimiters;
    }

    public boolean isUseDefaultDelimiters() {
        return this.useDefaultDelimiters;
    }

    public void setUseDefaultDelimiters(boolean useDefaultDelimiters) {
        this.useDefaultDelimiters = useDefaultDelimiters;
    }

    public boolean isSkip() {
        return this.skip;
    }

    protected Log getLog() {
        return this.logger;
    }
}

