/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources.remote;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-remote-resources-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Remote Resources Plugin", 0);
        this.append(sb, "Process resources packaged in JARs that have been deployed to a remote repository. The primary use case being satisfied is the consistent inclusion of common resources in a large set of projects. Maven projects at Apache use this plug-in to satisfy licensing requirements at Apache where each project much include license and notice files for each release.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "bundle".equals(this.goal)) {
            this.append(sb, "remote-resources:bundle", 0);
            this.append(sb, "Bundle up resources that should be considered as a remote-resource.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of files to exclude. Can contain ant-style wildcards and double wildcards.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of files to include. Can contain ant-style wildcards and double wildcards. The default includes are **/*.txt **/*.vm", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory where you want the resource bundle manifest written to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourcesDirectory", 2);
                this.append(sb, "The directory which contains the resources you want packaged up in this resource bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding", 2);
                this.append(sb, "Encoding of the bundle.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "remote-resources:help", 0);
            this.append(sb, "Display help information on maven-remote-resources-plugin.\nCall\n\u00a0\u00a0mvn\u00a0remote-resources:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "process".equals(this.goal)) {
            this.append(sb, "remote-resources:process", 0);
            this.append(sb, "Pull down resourceBundles containing remote resources and process the resources contained inside. When that is done the resources are injected into the current (in-memory) Maven project, making them available to the process-resources phase.\n\nResources that end in '.vm' are treated as velocity templates. For those, the '.vm' is stripped off for the final artifact name and it's fed through velocity to have properties expanded, conditions processed, etc...\n\nResources that don't end in '.vm' are copied 'as is'.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "appendedResourcesDirectory", 2);
                this.append(sb, "The directory containing extra information appended to the generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attached (Default: true)", 2);
                this.append(sb, "Attaches the resource to the project as a resource directory", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding scheme to be applied when filtering resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeArtifactIds", 2);
                this.append(sb, "Comma separated list of Artifact names too exclude.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeGroupIds", 2);
                this.append(sb, "Comma separated list of GroupId Names to exclude.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeScope", 2);
                this.append(sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeTransitive (Default: false)", 2);
                this.append(sb, "If we should exclude transitive dependencies", 3);
                this.append(sb, "", 0);
                this.append(sb, "filterDelimiters", 2);
                this.append(sb, "In cases where a local resource overrides one from a remote resource bundle, that resource should be filtered if the resource set specifies it. In those cases, this parameter defines the list of delimiters for filterable expressions. These delimiters are specified in the form 'beginToken*endToken'. If no '*' is given, the delimiter is assumed to be the same for start and end.\n\nSo, the default filtering delimiters might be specified as:\n\n<delimiters>\n<delimiter>${*}</delimiter>\n<delimiter>@</delimiter>\n</delimiters>\n\nSince the '@' delimiter is the same on both ends, we don't need to specify '@*@' (though we can).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeArtifactIds", 2);
                this.append(sb, "Comma separated list of Artifact names to include.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeGroupIds", 2);
                this.append(sb, "Comma separated list of GroupIds to include.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeScope (Default: runtime)", 2);
                this.append(sb, "Scope to include. An Empty string indicates all scopes (default).", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory where processed resources will be placed for packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Additional properties to be passed to velocity.\n>Several properties are automatically added:\nproject - the current MavenProject\nprojects - the list of dependency projects\nprojectTimespan - the timespan of the current project (requires inceptionYear in pom)\n\n\n>See the javadoc for MavenProject for information about the properties on the MavenProject.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceBundles", 2);
                this.append(sb, "The resource bundles that will be retrieved and processed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runOnlyAtExecutionRoot (Default: false)", 2);
                this.append(sb, "If true, only generate resources in the directory of the root project in a multimodule build. Dependencies from all modules will be aggregated before resource-generation takes place.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip remote-resource processing", 3);
                this.append(sb, "", 0);
                this.append(sb, "supplementalModelArtifacts", 2);
                this.append(sb, "List of artifacts that are added to the search path when looking for supplementalModels", 3);
                this.append(sb, "", 0);
                this.append(sb, "supplementalModels", 2);
                this.append(sb, "Supplemental model data. Useful when processing artifacts with incomplete POM metadata.\n>By default, this Mojo looks for supplemental model data in the file '${appendedResourcesDirectory}\nsupplemental-models.xml'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultFilterDelimiters (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

