/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractReleaseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private File basedir;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(alias="prepareVerifyArgs", property="arguments")
    private String arguments;
    @Parameter(property="pomFileName", defaultValue="${project.file.name}")
    private String pomFileName;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${maven.home}")
    private File mavenHome;
    @Parameter(defaultValue="${java.home}")
    private File javaHome;
    @Parameter(defaultValue="${maven.repo.local}")
    private File localRepoDirectory;
    @Parameter(defaultValue="invoker", property="mavenExecutorId")
    private String mavenExecutorId;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="default", property="releaseStrategyId")
    private String releaseStrategyId;
    protected ReleaseManager releaseManager;

    protected AbstractReleaseMojo(ReleaseManager releaseManager) {
        this.releaseManager = releaseManager;
    }

    protected ReleaseEnvironment getReleaseEnvironment() {
        return new DefaultReleaseEnvironment().setSettings(this.settings).setJavaHome(this.javaHome).setMavenHome(this.mavenHome).setLocalRepositoryDirectory(this.localRepoDirectory).setMavenExecutorId(this.mavenExecutorId);
    }

    protected ReleaseDescriptorBuilder createReleaseDescriptor() {
        Path workingDirectory;
        ReleaseDescriptorBuilder descriptor = new ReleaseDescriptorBuilder();
        descriptor.setInteractive(this.settings.isInteractiveMode());
        try {
            workingDirectory = AbstractReleaseMojo.getCommonBasedir(this.reactorProjects);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        descriptor.setWorkingDirectory(workingDirectory.toFile().getAbsolutePath());
        Path rootBasedir = this.basedir.toPath();
        if (rootBasedir.equals(workingDirectory)) {
            descriptor.setPomFileName(this.pomFileName);
        } else {
            descriptor.setPomFileName(workingDirectory.relativize(rootBasedir).resolve(this.pomFileName).toString());
        }
        for (MavenProject project : this.reactorProjects) {
            String versionlessKey = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            descriptor.putOriginalVersion(versionlessKey, project.getVersion());
        }
        descriptor.setAdditionalArguments(this.arguments);
        List profileIds = this.session.getRequest().getActiveProfiles();
        String additionalProfiles = this.getAdditionalProfiles();
        if (!profileIds.isEmpty() || StringUtils.isNotBlank((String)additionalProfiles)) {
            ArrayList<String> profiles = new ArrayList<String>(profileIds);
            if (additionalProfiles != null) {
                profiles.addAll(Arrays.asList(additionalProfiles.split(",")));
            }
            descriptor.setActivateProfiles(profiles);
        }
        descriptor.setReleaseStrategyId(this.releaseStrategyId);
        return descriptor;
    }

    protected String getAdditionalProfiles() {
        return null;
    }

    void setReleaseManager(ReleaseManager releaseManager) {
        this.releaseManager = releaseManager;
    }

    Settings getSettings() {
        return this.settings;
    }

    protected final File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setPomFileName(String pomFileName) {
        this.pomFileName = pomFileName;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected void addArgument(String argument) {
        this.arguments = this.arguments != null ? this.arguments + " " + argument : argument;
    }

    static Path getCommonBasedir(List<MavenProject> reactorProjects) throws IOException {
        Path basePath = reactorProjects.get(0).getBasedir().toPath();
        for (MavenProject reactorProject : reactorProjects) {
            Path matchPath = reactorProject.getBasedir().toPath();
            while (!basePath.startsWith(matchPath)) {
                matchPath = matchPath.getParent();
            }
            basePath = matchPath;
        }
        return basePath;
    }
}

