/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractScmReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseUtils;

@Mojo(name="branch", aggregator=true)
public class BranchReleaseMojo
extends AbstractScmReleaseMojo {
    @Parameter(property="branchName", required=true)
    private String branchName;
    @Parameter(property="branchBase")
    private String branchBase;
    @Parameter(defaultValue="false", property="updateBranchVersions")
    private boolean updateBranchVersions;
    @Parameter(defaultValue="true", property="updateWorkingCopyVersions")
    private boolean updateWorkingCopyVersions;
    @Parameter(defaultValue="false", property="suppressCommitBeforeBranch")
    private boolean suppressCommitBeforeBranch;
    @Parameter(defaultValue="true", property="updateVersionsToSnapshot")
    private boolean updateVersionsToSnapshot;
    @Parameter(defaultValue="false", property="useEditMode")
    private boolean useEditMode;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;
    @Parameter(defaultValue="true", property="addSchema")
    private boolean addSchema;
    @Parameter(defaultValue="true", property="remoteTagging")
    private boolean remoteTagging;
    @Parameter
    private String[] checkModificationExcludes;
    @Parameter(property="checkModificationExcludeList")
    private String checkModificationExcludeList;
    @Parameter(property="releaseVersion")
    private String releaseVersion;
    @Parameter(property="developmentVersion")
    private String developmentVersion;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptor config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setScmUseEditMode(this.useEditMode);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setScmReleaseLabel(this.branchName);
        config.setScmBranchBase(this.branchBase);
        config.setBranchCreation(true);
        config.setUpdateBranchVersions(this.updateBranchVersions);
        config.setUpdateWorkingCopyVersions(this.updateWorkingCopyVersions);
        config.setUpdateVersionsToSnapshot(this.updateVersionsToSnapshot);
        config.setRemoteTagging(this.remoteTagging);
        config.setDefaultReleaseVersion(this.releaseVersion);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setSuppressCommitBeforeTagOrBranch(this.suppressCommitBeforeBranch);
        ReleaseDescriptor sysPropertiesConfig = ReleaseUtils.copyPropertiesToReleaseDescriptor((Properties)this.session.getExecutionProperties());
        this.mergeCommandLineConfig(config, sysPropertiesConfig);
        if (this.checkModificationExcludeList != null) {
            this.checkModificationExcludes = this.checkModificationExcludeList.replaceAll("\\s", "").split(",");
        }
        if (this.checkModificationExcludes != null) {
            config.setCheckModificationExcludes(Arrays.asList(this.checkModificationExcludes));
        }
        try {
            this.releaseManager.branch(config, this.getReleaseEnvironment(), this.getReactorProjects(), this.dryRun);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

