/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractScmReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseUtils;

@Mojo(name="prepare", aggregator=true)
public class PrepareReleaseMojo
extends AbstractScmReleaseMojo {
    @Parameter(defaultValue="true", property="resume")
    private boolean resume;
    @Parameter(defaultValue="false", property="generateReleasePoms")
    private boolean generateReleasePoms;
    @Parameter(defaultValue="false", property="useEditMode")
    private boolean useEditMode;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;
    @Parameter(defaultValue="true", property="addSchema")
    private boolean addSchema;
    @Parameter(defaultValue="clean verify", property="preparationGoals")
    private String preparationGoals;
    @Parameter(defaultValue="", property="completionGoals")
    private String completionGoals;
    @Parameter(defaultValue="false", property="commitByProject")
    private boolean commitByProject;
    @Parameter(defaultValue="false", property="ignoreSnapshots")
    private boolean allowTimestampedSnapshots;
    @Parameter(defaultValue="false", property="allowReleasePluginSnapshot", readonly=true)
    private boolean allowReleasePluginSnapshot;
    @Parameter
    private String[] checkModificationExcludes;
    @Parameter(property="checkModificationExcludeList")
    private String checkModificationExcludeList;
    @Parameter(property="releaseVersion")
    private String releaseVersion;
    @Parameter(property="developmentVersion")
    private String developmentVersion;
    @Parameter(defaultValue="true", property="remoteTagging")
    private boolean remoteTagging;
    @Parameter(defaultValue="true", property="updateWorkingCopyVersions")
    private boolean updateWorkingCopyVersions;
    @Parameter(defaultValue="false", property="suppressCommitBeforeTag")
    private boolean suppressCommitBeforeTag;
    @Parameter(defaultValue="0", property="waitBeforeTagging")
    private int waitBeforeTagging;
    @Parameter(defaultValue="default", property="projectVersionPolicyId")
    private String projectVersionPolicyId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.generateReleasePoms) {
            throw new MojoFailureException("Generating release POMs is no longer supported in release:prepare. Please run release:prepare-with-pom instead.");
        }
        this.prepareRelease(this.generateReleasePoms);
    }

    protected void prepareRelease(boolean generateReleasePoms) throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptor config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setGenerateReleasePoms(generateReleasePoms);
        config.setScmUseEditMode(this.useEditMode);
        config.setPreparationGoals(this.preparationGoals);
        config.setCompletionGoals(this.completionGoals);
        config.setCommitByProject(this.commitByProject);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setAllowTimestampedSnapshots(this.allowTimestampedSnapshots);
        config.setSnapshotReleasePluginAllowed(this.allowReleasePluginSnapshot);
        config.setDefaultReleaseVersion(this.releaseVersion);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setRemoteTagging(this.remoteTagging);
        config.setUpdateWorkingCopyVersions(this.updateWorkingCopyVersions);
        config.setSuppressCommitBeforeTagOrBranch(this.suppressCommitBeforeTag);
        config.setWaitBeforeTagging(this.waitBeforeTagging);
        config.setProjectVersionPolicyId(this.projectVersionPolicyId);
        if (this.checkModificationExcludeList != null) {
            this.checkModificationExcludes = this.checkModificationExcludeList.replaceAll("\\s", "").split(",");
        }
        if (this.checkModificationExcludes != null) {
            config.setCheckModificationExcludes(Arrays.asList(this.checkModificationExcludes));
        }
        ReleaseDescriptor sysPropertiesConfig = ReleaseUtils.copyPropertiesToReleaseDescriptor((Properties)this.session.getExecutionProperties());
        this.mergeCommandLineConfig(config, sysPropertiesConfig);
        try {
            this.releaseManager.prepare(config, this.getReleaseEnvironment(), this.getReactorProjects(), this.resume, this.dryRun);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

