/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.reactor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.reactor.MakeDependentsMojo;
import org.apache.maven.plugin.reactor.NonReactorException;
import org.apache.maven.plugin.reactor.RelativePather;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="make-scm-changes", aggregator=true, defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class MakeScmChanges
extends MakeDependentsMojo {
    @Parameter(property="make.scmConnection", defaultValue="${project.scm.connection}", required=true)
    String scmConnection;
    @Parameter(property="make.ignoreUnknown", defaultValue="true")
    private boolean ignoreUnknown = true;
    @Component
    ScmManager scmManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StatusScmResult result;
        if (this.collectedProjects.size() == 0) {
            throw new NonReactorException();
        }
        if (this.scmConnection == null) {
            throw new MojoFailureException("No SCM connection specified.  You must specify an SCM connection by adding a <connection> element to your <scm> element in your POM");
        }
        try {
            ScmRepository repository = this.scmManager.makeScmRepository(this.scmConnection);
            result = this.scmManager.status(repository, new ScmFileSet(this.baseDir));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't configure SCM repository: " + e.getLocalizedMessage(), e);
        }
        List changedFiles = result.getChangedFiles();
        List projectDirectories = this.getProjectDirectories();
        HashSet<String> changedDirectories = new HashSet<String>();
        for (Object changedFile1 : changedFiles) {
            ScmFile changedScmFile = (ScmFile)changedFile1;
            this.getLog().debug((CharSequence)changedScmFile.toString());
            ScmFileStatus status = changedScmFile.getStatus();
            if (!status.isStatus()) {
                this.getLog().debug((CharSequence)("Not a diff: " + status));
                continue;
            }
            if (this.ignoreUnknown && ScmFileStatus.UNKNOWN.equals(status)) {
                this.getLog().debug((CharSequence)"Ignoring unknown");
                continue;
            }
            File changedFile = new File(changedScmFile.getPath());
            boolean found = false;
            for (Object projectDirectory1 : projectDirectories) {
                File projectDirectory = (File)projectDirectory1;
                if (!changedFile.getAbsolutePath().startsWith(projectDirectory.getAbsolutePath() + File.separator)) continue;
                String path = RelativePather.getRelativePath(this.baseDir, projectDirectory);
                if (!changedDirectories.contains(path)) {
                    this.getLog().debug((CharSequence)("Including " + path));
                }
                changedDirectories.add(path);
                found = true;
                break;
            }
            if (found) continue;
            this.getLog().debug((CharSequence)("Couldn't find file in any reactor root: " + changedFile.getAbsolutePath()));
        }
        this.folderList = StringUtils.join(changedDirectories.iterator(), (String)",");
        this.getLog().info((CharSequence)("Going to make dependents for: " + this.folderList));
        super.execute();
    }

    private List getProjectDirectories() {
        ArrayList<File> dirs = new ArrayList<File>(this.collectedProjects.size());
        for (Object collectedProject : this.collectedProjects) {
            MavenProject mp = (MavenProject)collectedProject;
            dirs.add(mp.getFile().getParentFile());
        }
        return dirs;
    }
}

