/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.reactor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.reactor.MissingProjectException;
import org.apache.maven.plugin.reactor.NonReactorException;
import org.apache.maven.plugin.reactor.RelativePather;
import org.apache.maven.plugin.reactor.ResumeMojo;
import org.apache.maven.plugin.reactor.SimpleInvoker;
import org.apache.maven.plugin.reactor.SuperProjectSorter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.Invoker;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.Vertex;

@Mojo(name="make", aggregator=true, defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class MakeMojo
extends AbstractMojo {
    @Parameter(property="basedir")
    File baseDir;
    @Parameter(property="project.collectedProjects")
    List collectedProjects;
    @Parameter(property="make.group", defaultValue="${project.groupId}")
    String defaultGroup;
    @Parameter(property="make.artifacts", defaultValue="", required=true)
    String artifactList;
    @Parameter(property="make.folders", defaultValue="", required=true)
    String folderList;
    @Parameter(property="make.goals", defaultValue="install")
    String goals;
    @Component
    Invoker invoker;
    @Parameter(property="make.printOnly")
    private boolean printOnly = false;
    @Component
    SimpleInvoker simpleInvoker;
    @Parameter(property="fromArtifact")
    String continueFromProject;
    @Parameter(property="from")
    File continueFromFolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] reactorIncludes;
        List sortedProjects;
        if (this.artifactList == null && this.folderList == null) {
            throw new MojoFailureException("You must specify either folders or projects with -Dmake.folders=foo,baz/bar or -Dmake.artifacts=com.mycompany:foo,com.mycompany:bar");
        }
        try {
            if (this.collectedProjects.size() == 0) {
                throw new NonReactorException();
            }
            SuperProjectSorter ps = new SuperProjectSorter(this.collectedProjects);
            DAG dag = ps.getDAG();
            this.collectArtifactListFromFolderList(this.collectedProjects);
            String[] artifacts = StringUtils.split((String)this.artifactList, (String)",");
            HashSet visited = new HashSet();
            HashSet out = new HashSet();
            for (String artifact : artifacts) {
                Vertex projectVertex;
                String project = artifact;
                if (project.indexOf(58) == -1) {
                    project = this.defaultGroup + ":" + project;
                }
                if ((projectVertex = dag.getVertex(project)) == null) {
                    throw new MissingProjectException(project);
                }
                this.gatherProjects(projectVertex, ps, visited, out);
            }
            ps = new SuperProjectSorter(new ArrayList(out));
            sortedProjects = ps.getSortedProjects();
            reactorIncludes = new String[sortedProjects.size()];
            for (int i = 0; i < sortedProjects.size(); ++i) {
                String path;
                MavenProject mp = (MavenProject)sortedProjects.get(i);
                reactorIncludes[i] = path = RelativePather.getRelativePath(this.baseDir, mp.getFile());
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem generating dependency tree", e);
        }
        if (this.continueFromFolder != null || this.continueFromProject != null) {
            ResumeMojo resumer = new ResumeMojo();
            resumer.baseDir = this.baseDir;
            resumer.collectedProjects = sortedProjects;
            resumer.continueFromFolder = this.continueFromFolder;
            resumer.continueFromProject = this.continueFromProject;
            resumer.goals = this.goals;
            resumer.invoker = this.invoker;
            resumer.simpleInvoker = this.simpleInvoker;
            resumer.printOnly = this.printOnly;
            resumer.continueFromGroup = this.defaultGroup;
            resumer.execute();
        } else {
            this.simpleInvoker.runReactor(reactorIncludes, Arrays.asList(this.goals.split(",")), this.invoker, this.printOnly, this.getLog());
        }
    }

    void collectArtifactListFromFolderList(List collectedProjects) throws MojoFailureException {
        if (this.folderList == null) {
            return;
        }
        String[] folders = StringUtils.split((String)this.folderList, (String)",");
        HashSet<String> pathSet = new HashSet<String>();
        for (String folder : folders) {
            File file = new File(this.baseDir, folder);
            if (!file.exists()) {
                throw new MojoFailureException("Folder doesn't exist: " + file.getAbsolutePath());
            }
            String path = file.getAbsolutePath();
            pathSet.add(path);
        }
        if (this.artifactList == null) {
            this.artifactList = "";
        }
        StringBuilder artifactBuffer = new StringBuilder(this.artifactList);
        for (Object collectedProject : collectedProjects) {
            MavenProject mp = (MavenProject)collectedProject;
            if (!pathSet.contains(mp.getFile().getParentFile().getAbsolutePath())) continue;
            if (artifactBuffer.length() > 0) {
                artifactBuffer.append(',');
            }
            String id = ArtifactUtils.versionlessKey((String)mp.getGroupId(), (String)mp.getArtifactId());
            artifactBuffer.append(id);
        }
        if (artifactBuffer.length() == 0) {
            throw new MojoFailureException("No folders matched: " + this.folderList);
        }
        this.artifactList = artifactBuffer.toString();
    }

    protected Set gatherProjects(Vertex v, SuperProjectSorter ps, Set visited, Set out) {
        visited.add(v);
        out.add(ps.getProjectMap().get(v.getLabel()));
        List children = v.getChildren();
        for (Object aChildren : children) {
            Vertex child = (Vertex)aChildren;
            if (visited.contains(child)) continue;
            this.gatherProjects(child, ps, visited, out);
        }
        return out;
    }
}

