package org.apache.maven.plugin.reactor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-reactor-plugin.<br/> Call <pre>  mvn reactor:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Sep 23 13:12:03 PDT 2008
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.4.3)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-reactor-plugin:1.0", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Reactor Plugin 1.0", 0 );
        append( sb, "Build a subset of interdependent projects in a reactor", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 5 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "reactor:help", 0 );
            append( sb, "Display help information on maven-reactor-plugin.\nCall\n\u00a0\u00a0mvn\u00a0reactor:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "make".equals( goal ) )
        {
            append( sb, "reactor:make", 0 );
            append( sb, "Goal to build a project X and all of the reactor projects on which X depends", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactList", 2 );
                append( sb, "A list of artifacts to build, e.g. \'com.mycompany:bar,com.mycompany:foo\' or just \'foo,bar\', or just \'foo\'", 3 );
                append( sb, "", 0 );

                append( sb, "baseDir", 2 );
                append( sb, "Location of the POM file; provided by Maven", 3 );
                append( sb, "", 0 );

                append( sb, "collectedProjects", 2 );
                append( sb, "A list of every project in this reactor; provided by Maven", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromFolder", 2 );
                append( sb, "The project folder from which we\'ll resume", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromProject", 2 );
                append( sb, "The artifact from which we\'ll resume, e.g. \'com.mycompany:foo\' or just \'foo\'", 3 );
                append( sb, "", 0 );

                append( sb, "defaultGroup (Default: ${project.groupId})", 2 );
                append( sb, "If you don\'t specify a groupId in your artifactList, we\'ll use this as the default groupId.", 3 );
                append( sb, "", 0 );

                append( sb, "folderList", 2 );
                append( sb, "A list of relative paths to build, e.g. \'foo,baz/bar\'", 3 );
                append( sb, "", 0 );

                append( sb, "goals (Default: install)", 2 );
                append( sb, "Goals to run on subproject.", 3 );
                append( sb, "", 0 );

                append( sb, "printOnly", 2 );
                append( sb, "Don\'t really do anything; just print a command that describes what the command would have done", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "make-dependents".equals( goal ) )
        {
            append( sb, "reactor:make-dependents", 0 );
            append( sb, "Goal to build a project X and all of the reactor projects that depend on X", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactList", 2 );
                append( sb, "A list of artifacts to build, e.g. \'com.mycompany:bar,com.mycompany:foo\' or just \'foo,bar\', or just \'foo\'", 3 );
                append( sb, "", 0 );

                append( sb, "baseDir", 2 );
                append( sb, "Location of the POM file; provided by Maven", 3 );
                append( sb, "", 0 );

                append( sb, "collectedProjects", 2 );
                append( sb, "A list of every project in this reactor; provided by Maven", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromFolder", 2 );
                append( sb, "The project folder from which we\'ll resume", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromProject", 2 );
                append( sb, "The artifact from which we\'ll resume, e.g. \'com.mycompany:foo\' or just \'foo\'", 3 );
                append( sb, "", 0 );

                append( sb, "defaultGroup (Default: ${project.groupId})", 2 );
                append( sb, "If you don\'t specify a groupId in your artifactList, we\'ll use this as the default groupId.", 3 );
                append( sb, "", 0 );

                append( sb, "folderList", 2 );
                append( sb, "A list of relative paths to build, e.g. \'foo,baz/bar\'", 3 );
                append( sb, "", 0 );

                append( sb, "goals (Default: install)", 2 );
                append( sb, "Goals to run on subproject.", 3 );
                append( sb, "", 0 );

                append( sb, "printOnly", 2 );
                append( sb, "Don\'t really do anything; just print a command that describes what the command would have done", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "make-scm-changes".equals( goal ) )
        {
            append( sb, "reactor:make-scm-changes", 0 );
            append( sb, "Goal to build all projects that you personally have changed (according to SCM)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactList", 2 );
                append( sb, "A list of artifacts to build, e.g. \'com.mycompany:bar,com.mycompany:foo\' or just \'foo,bar\', or just \'foo\'", 3 );
                append( sb, "", 0 );

                append( sb, "baseDir", 2 );
                append( sb, "Location of the POM file; provided by Maven", 3 );
                append( sb, "", 0 );

                append( sb, "collectedProjects", 2 );
                append( sb, "A list of every project in this reactor; provided by Maven", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromFolder", 2 );
                append( sb, "The project folder from which we\'ll resume", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromProject", 2 );
                append( sb, "The artifact from which we\'ll resume, e.g. \'com.mycompany:foo\' or just \'foo\'", 3 );
                append( sb, "", 0 );

                append( sb, "defaultGroup (Default: ${project.groupId})", 2 );
                append( sb, "If you don\'t specify a groupId in your artifactList, we\'ll use this as the default groupId.", 3 );
                append( sb, "", 0 );

                append( sb, "folderList", 2 );
                append( sb, "A list of relative paths to build, e.g. \'foo,baz/bar\'", 3 );
                append( sb, "", 0 );

                append( sb, "goals (Default: install)", 2 );
                append( sb, "Goals to run on subproject.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreUnknown (Default: true)", 2 );
                append( sb, "Ignore files in the \'unknown\' status (created but not added to source control)", 3 );
                append( sb, "", 0 );

                append( sb, "printOnly", 2 );
                append( sb, "Don\'t really do anything; just print a command that describes what the command would have done", 3 );
                append( sb, "", 0 );

                append( sb, "scmConnection (Default: ${project.scm.connection})", 2 );
                append( sb, "The SCM connection/provider info. Should be specified in your POM.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resume".equals( goal ) )
        {
            append( sb, "reactor:resume", 0 );
            append( sb, "Goal to resume building a reactor at a certain point", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "baseDir", 2 );
                append( sb, "Location of the file.", 3 );
                append( sb, "", 0 );

                append( sb, "collectedProjects", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromFolder (Default: null)", 2 );
                append( sb, "The project folder from which we\'ll resume", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromGroup (Default: ${project.groupId})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "continueFromProject (Default: null)", 2 );
                append( sb, "The artifact from which we\'ll resume, e.g. \'com.mycompany:foo\' or just \'foo\'", 3 );
                append( sb, "", 0 );

                append( sb, "goals (Default: install)", 2 );
                append( sb, "Goals to run on subproject", 3 );
                append( sb, "", 0 );

                append( sb, "printOnly", 2 );
                append( sb, "Don\'t really do anything; just print a message that describes what the command would have done", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
