/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.rar;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class RarMojo
extends AbstractMojo {
    public static final String RA_XML_URI = "META-INF/ra.xml";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private File rarSourceDirectory;
    private File raXmlFile;
    private Boolean includeJar = Boolean.TRUE;
    private File manifestFile;
    private String workDirectory;
    private String outputDirectory;
    private String finalName;
    private MavenProject project;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File buildDir;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)" ======= RarMojo settings =======");
        this.getLog().debug((CharSequence)("rarSourceDirectory[" + this.rarSourceDirectory + "]"));
        this.getLog().debug((CharSequence)("manifestFile[" + this.manifestFile + "]"));
        this.getLog().debug((CharSequence)("raXmlFile[" + this.raXmlFile + "]"));
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("outputDirectory[" + this.outputDirectory + "]"));
        this.getLog().debug((CharSequence)("finalName[" + this.finalName + "]"));
        try {
            File generatedJarFile;
            if (this.includeJar.booleanValue() && (generatedJarFile = new File(this.outputDirectory, this.finalName + ".jar")).exists()) {
                this.getLog().info((CharSequence)("Including generated jar file[" + generatedJarFile.getName() + "]"));
                FileUtils.copyFileToDirectory((File)generatedJarFile, (File)this.getBuildDir());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated Jar file", (Exception)e);
        }
        try {
            Set artifacts = this.project.getArtifacts();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
                if (artifact.isOptional() || !filter.include(artifact)) continue;
                this.getLog().info((CharSequence)("Copying artifact[" + artifact.getGroupId() + ", " + artifact.getId() + ", " + artifact.getScope() + "]"));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)this.getBuildDir());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying RAR dependencies", (Exception)e);
        }
        try {
            File rarSourceDir = this.rarSourceDirectory;
            if (rarSourceDir.exists()) {
                this.getLog().info((CharSequence)("Copy rar resources to " + this.getBuildDir().getAbsolutePath()));
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(rarSourceDir.getAbsolutePath());
                scanner.setIncludes(DEFAULT_INCLUDES);
                scanner.addDefaultExcludes();
                scanner.scan();
                String[] dirs = scanner.getIncludedDirectories();
                for (int j = 0; j < dirs.length; ++j) {
                    new File(this.getBuildDir(), dirs[j]).mkdirs();
                }
                String[] files = scanner.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    File targetFile = new File(this.getBuildDir(), files[j]);
                    targetFile.getParentFile().mkdirs();
                    File file = new File(rarSourceDir, files[j]);
                    FileUtils.copyFileToDirectory((File)file, (File)targetFile.getParentFile());
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying RAR resources", e);
        }
        try {
            this.includeCustomRaXmlFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying ra.xml file", (Exception)e);
        }
        File ddFile = new File(this.getBuildDir(), RA_XML_URI);
        if (!ddFile.exists()) {
            this.getLog().warn((CharSequence)("Connector deployment descriptor: " + ddFile.getAbsolutePath() + " does not exist."));
        }
        try {
            File rarFile = new File(this.outputDirectory, this.finalName + ".rar");
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(rarFile);
            this.includeCustomManifestFile();
            archiver.getArchiver().addDirectory(this.getBuildDir());
            archiver.createArchive(this.project, this.archive);
            this.project.getArtifact().setFile(rarFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling RAR", e);
        }
    }

    protected File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = new File(this.workDirectory);
        }
        return this.buildDir;
    }

    private void includeCustomManifestFile() throws IOException {
        File customManifestFile = this.manifestFile;
        if (!customManifestFile.exists()) {
            this.getLog().info((CharSequence)("Could not find manifest file: " + this.manifestFile + " - Generating one"));
        } else {
            this.getLog().info((CharSequence)("Including custom manifest file[" + customManifestFile + "]"));
            this.archive.setManifestFile(customManifestFile);
            File metaInfDir = new File(this.getBuildDir(), "META-INF");
            FileUtils.copyFileToDirectory((File)customManifestFile, (File)metaInfDir);
        }
    }

    private void includeCustomRaXmlFile() throws IOException {
        File raXml;
        if (this.raXmlFile == null) {
            // empty if block
        }
        if ((raXml = this.raXmlFile).exists()) {
            this.getLog().info((CharSequence)("Using ra.xml " + this.raXmlFile));
            File metaInfDir = new File(this.getBuildDir(), "META-INF");
            FileUtils.copyFileToDirectory((File)raXml, (File)metaInfDir);
        }
    }
}

