/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.avatars.AvatarsProvider;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="team")
public class TeamReport
extends AbstractProjectInfoReport {
    @Parameter(property="teamlist.showAvatarImages", defaultValue="true")
    private boolean showAvatarImages;
    @Parameter(property="teamlist.externalAvatarImages", defaultValue="true")
    private boolean externalAvatarImages;
    @Parameter(property="teamlist.avatarBaseUrl", defaultValue="https://www.gravatar.com/avatar/")
    private String avatarBaseUrl;
    @Parameter(property="teamlist.avatarProviderName", defaultValue="gravatar")
    private String avatarProviderName;
    private final Map<String, AvatarsProvider> avatarsProviders;

    @Inject
    public TeamReport(RepositorySystem repositorySystem, I18N i18n, ProjectBuilder projectBuilder, Map<String, AvatarsProvider> avatarsProviders) {
        super(repositorySystem, i18n, projectBuilder);
        this.avatarsProviders = avatarsProviders;
    }

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = !this.isEmpty(this.getProject().getModel().getDevelopers()) || !this.isEmpty(this.getProject().getModel().getContributors());
        }
        return result;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        Map<Contributor, String> avatarImages = this.prepareAvatars();
        ProjectTeamRenderer renderer = new ProjectTeamRenderer(this.getSink(), this.project, this.getI18N(locale), locale, this.showAvatarImages, avatarImages);
        renderer.render();
    }

    private Map<Contributor, String> prepareAvatars() throws MavenReportException {
        if (!this.showAvatarImages) {
            return Collections.emptyMap();
        }
        AvatarsProvider avatarsProvider = this.avatarsProviders.get(this.avatarProviderName);
        if (avatarsProvider == null) {
            throw new MavenReportException("No AvatarsProvider found for name " + this.avatarProviderName);
        }
        avatarsProvider.setBaseUrl(this.avatarBaseUrl);
        avatarsProvider.setOutputDirectory(this.getReportOutputDirectory());
        HashMap<Contributor, String> result = new HashMap<Contributor, String>();
        try {
            this.prepareContributorAvatars(result, avatarsProvider, this.project.getDevelopers());
            this.prepareContributorAvatars(result, avatarsProvider, this.project.getContributors());
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to load avatar images", (Exception)e);
        }
        return result;
    }

    private void prepareContributorAvatars(Map<Contributor, String> avatarImages, AvatarsProvider avatarsProvider, List<? extends Contributor> contributors) throws IOException {
        for (Contributor contributor : contributors) {
            String picSource = contributor.getProperties().getProperty("picUrl");
            if (picSource == null || picSource.isEmpty()) {
                picSource = this.externalAvatarImages ? avatarsProvider.getAvatarUrl(contributor.getEmail()) : avatarsProvider.getLocalAvatarPath(contributor.getEmail());
            }
            avatarImages.put(contributor, picSource);
        }
    }

    public String getOutputName() {
        return "team";
    }

    @Override
    protected String getI18Nsection() {
        return "team";
    }

    private static class ProjectTeamRenderer
    extends AbstractProjectInfoRenderer {
        private static final String PROPERTIES = "properties";
        private static final String TIME_ZONE = "timeZone";
        private static final String ROLES = "roles";
        private static final String ORGANIZATION_URL = "organizationUrl";
        private static final String ORGANIZATION = "organization";
        private static final String URL = "url";
        private static final String EMAIL = "email";
        private static final String NAME = "name";
        private static final String IMAGE = "image";
        private static final String ID = "id";
        private final MavenProject mavenProject;
        private final boolean showAvatarImages;
        private final Map<Contributor, String> avatarImages;

        ProjectTeamRenderer(Sink sink, MavenProject mavenProject, I18N i18n, Locale locale, boolean showAvatarImages, Map<Contributor, String> avatarImages) {
            super(sink, i18n, locale);
            this.mavenProject = mavenProject;
            this.showAvatarImages = showAvatarImages;
            this.avatarImages = avatarImages;
        }

        @Override
        protected String getI18Nsection() {
            return "team";
        }

        protected void renderBody() {
            this.startSection(this.getI18nString("intro.title"));
            this.paragraph(this.getI18nString("intro.description1"));
            this.paragraph(this.getI18nString("intro.description2"));
            List developers = this.mavenProject.getDevelopers();
            this.startSection(this.getI18nString("developers.title"));
            if (developers.isEmpty()) {
                this.paragraph(this.getI18nString("nodeveloper"));
            } else {
                this.paragraph(this.getI18nString("developers.intro"));
                this.startTable();
                Map<String, Boolean> headersMap = ProjectTeamRenderer.checkRequiredHeaders(developers);
                String[] requiredHeaders = this.getRequiredDevHeaderArray(headersMap);
                this.tableHeader(requiredHeaders);
                for (Developer developer : developers) {
                    this.renderTeamMember((Contributor)developer, headersMap);
                }
                this.endTable();
            }
            this.endSection();
            List contributors = this.mavenProject.getContributors();
            this.startSection(this.getI18nString("contributors.title"));
            if (contributors.isEmpty()) {
                this.paragraph(this.getI18nString("nocontributor"));
            } else {
                this.paragraph(this.getI18nString("contributors.intro"));
                this.startTable();
                Map<String, Boolean> headersMap = ProjectTeamRenderer.checkRequiredHeaders(contributors);
                String[] requiredHeaders = this.getRequiredContrHeaderArray(headersMap);
                this.tableHeader(requiredHeaders);
                for (Contributor contributor : contributors) {
                    this.renderTeamMember(contributor, headersMap);
                }
                this.endTable();
            }
            this.endSection();
            this.endSection();
        }

        private void renderTeamMember(Contributor member, Map<String, Boolean> headersMap) {
            this.sink.tableRow();
            if (headersMap.get(IMAGE) == Boolean.TRUE && this.showAvatarImages) {
                this.sink.tableCell();
                this.sink.figure();
                this.sink.figureGraphics(this.avatarImages.get(member));
                this.sink.figure_();
                this.sink.tableCell_();
            }
            if (member instanceof Developer && headersMap.get(ID) == Boolean.TRUE) {
                String id = ((Developer)member).getId();
                if (id == null) {
                    this.tableCell(null);
                } else {
                    this.tableCell("<a id=\"" + id + "\"></a>" + id, true);
                }
            }
            if (headersMap.get(NAME) == Boolean.TRUE) {
                this.tableCell(member.getName());
            }
            if (headersMap.get(EMAIL) == Boolean.TRUE) {
                String link = String.format("mailto:%s", member.getEmail());
                this.tableCell(ProjectTeamRenderer.createLinkPatternedText((String)member.getEmail(), (String)link));
            }
            if (headersMap.get(URL) == Boolean.TRUE) {
                this.tableCellForUrl(member.getUrl());
            }
            if (headersMap.get(ORGANIZATION) == Boolean.TRUE) {
                this.tableCell(member.getOrganization());
            }
            if (headersMap.get(ORGANIZATION_URL) == Boolean.TRUE) {
                this.tableCellForUrl(member.getOrganizationUrl());
            }
            if (headersMap.get(ROLES) == Boolean.TRUE) {
                if (member.getRoles() != null) {
                    List var = member.getRoles();
                    this.tableCell(StringUtils.join((Object[])var.toArray(new String[var.size()]), (String)", "));
                } else {
                    this.tableCell(null);
                }
            }
            if (headersMap.get(TIME_ZONE) == Boolean.TRUE) {
                this.tableCell(member.getTimezone());
            }
            if (headersMap.get(PROPERTIES) == Boolean.TRUE) {
                Properties props = member.getProperties();
                if (props != null) {
                    this.tableCell(ProjectTeamRenderer.propertiesToString((Properties)props));
                } else {
                    this.tableCell(null);
                }
            }
            this.sink.tableRow_();
        }

        private String[] getRequiredContrHeaderArray(Map<String, Boolean> requiredHeaders) {
            ArrayList<String> requiredArray = new ArrayList<String>();
            String image = this.getI18nString("contributors.image");
            String name = this.getI18nString("contributors.name");
            String email = this.getI18nString("contributors.email");
            String url = this.getI18nString("contributors.url");
            String organization = this.getI18nString("contributors.organization");
            String organizationUrl = this.getI18nString("contributors.organizationurl");
            String roles = this.getI18nString("contributors.roles");
            String timeZone = this.getI18nString("contributors.timezone");
            String properties = this.getI18nString("contributors.properties");
            if (requiredHeaders.get(IMAGE) == Boolean.TRUE && this.showAvatarImages) {
                requiredArray.add(image);
            }
            ProjectTeamRenderer.setRequiredArray(requiredHeaders, requiredArray, name, email, url, organization, organizationUrl, roles, timeZone, properties);
            return requiredArray.toArray(new String[requiredArray.size()]);
        }

        private String[] getRequiredDevHeaderArray(Map<String, Boolean> requiredHeaders) {
            ArrayList<String> requiredArray = new ArrayList<String>();
            String image = this.getI18nString("developers.image");
            String id = this.getI18nString("developers.id");
            String name = this.getI18nString("developers.name");
            String email = this.getI18nString("developers.email");
            String url = this.getI18nString("developers.url");
            String organization = this.getI18nString("developers.organization");
            String organizationUrl = this.getI18nString("developers.organizationurl");
            String roles = this.getI18nString("developers.roles");
            String timeZone = this.getI18nString("developers.timezone");
            String properties = this.getI18nString("developers.properties");
            if (requiredHeaders.get(IMAGE) == Boolean.TRUE && this.showAvatarImages) {
                requiredArray.add(image);
            }
            if (requiredHeaders.get(ID) == Boolean.TRUE) {
                requiredArray.add(id);
            }
            ProjectTeamRenderer.setRequiredArray(requiredHeaders, requiredArray, name, email, url, organization, organizationUrl, roles, timeZone, properties);
            return requiredArray.toArray(new String[0]);
        }

        private static void setRequiredArray(Map<String, Boolean> requiredHeaders, List<String> requiredArray, String name, String email, String url, String organization, String organizationUrl, String roles, String timeZone, String properties) {
            if (requiredHeaders.get(NAME) == Boolean.TRUE) {
                requiredArray.add(name);
            }
            if (requiredHeaders.get(EMAIL) == Boolean.TRUE) {
                requiredArray.add(email);
            }
            if (requiredHeaders.get(URL) == Boolean.TRUE) {
                requiredArray.add(url);
            }
            if (requiredHeaders.get(ORGANIZATION) == Boolean.TRUE) {
                requiredArray.add(organization);
            }
            if (requiredHeaders.get(ORGANIZATION_URL) == Boolean.TRUE) {
                requiredArray.add(organizationUrl);
            }
            if (requiredHeaders.get(ROLES) == Boolean.TRUE) {
                requiredArray.add(roles);
            }
            if (requiredHeaders.get(TIME_ZONE) == Boolean.TRUE) {
                requiredArray.add(timeZone);
            }
            if (requiredHeaders.get(PROPERTIES) == Boolean.TRUE) {
                requiredArray.add(properties);
            }
        }

        private static Map<String, Boolean> checkRequiredHeaders(List<? extends Contributor> units) {
            HashMap<String, Boolean> requiredHeaders = new HashMap<String, Boolean>();
            requiredHeaders.put(IMAGE, Boolean.FALSE);
            requiredHeaders.put(ID, Boolean.FALSE);
            requiredHeaders.put(NAME, Boolean.FALSE);
            requiredHeaders.put(EMAIL, Boolean.FALSE);
            requiredHeaders.put(URL, Boolean.FALSE);
            requiredHeaders.put(ORGANIZATION, Boolean.FALSE);
            requiredHeaders.put(ORGANIZATION_URL, Boolean.FALSE);
            requiredHeaders.put(ROLES, Boolean.FALSE);
            requiredHeaders.put(TIME_ZONE, Boolean.FALSE);
            requiredHeaders.put(PROPERTIES, Boolean.FALSE);
            for (Contributor contributor : units) {
                boolean isJustAnImageProperty;
                Properties properties;
                boolean hasPicUrl;
                Developer developer;
                if (contributor instanceof Developer && StringUtils.isNotEmpty((String)(developer = (Developer)contributor).getId())) {
                    requiredHeaders.put(ID, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getName())) {
                    requiredHeaders.put(NAME, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getEmail())) {
                    requiredHeaders.put(EMAIL, Boolean.TRUE);
                    requiredHeaders.put(IMAGE, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getUrl())) {
                    requiredHeaders.put(URL, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getOrganization())) {
                    requiredHeaders.put(ORGANIZATION, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getOrganizationUrl())) {
                    requiredHeaders.put(ORGANIZATION_URL, Boolean.TRUE);
                }
                if (!contributor.getRoles().isEmpty()) {
                    requiredHeaders.put(ROLES, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getTimezone())) {
                    requiredHeaders.put(TIME_ZONE, Boolean.TRUE);
                }
                if (hasPicUrl = (properties = contributor.getProperties()).containsKey("picUrl")) {
                    requiredHeaders.put(IMAGE, Boolean.TRUE);
                }
                if ((isJustAnImageProperty = properties.size() == 1 && hasPicUrl) || properties.isEmpty()) continue;
                requiredHeaders.put(PROPERTIES, Boolean.TRUE);
            }
            return requiredHeaders;
        }

        private void tableCellForUrl(String url) {
            this.sink.tableCell();
            if (url == null || url.isEmpty()) {
                this.text(url);
            } else {
                this.link(url, url);
            }
            this.sink.tableCell_();
        }
    }
}

