/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.validator.UrlValidator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.Base64;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInfoReportUtils {
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(new String[]{"http", "https"});
    private static final int TIMEOUT = 5000;

    public static String getContent(URL url, Settings settings) throws IOException {
        return ProjectInfoReportUtils.getContent(url, settings, "ISO-8859-1");
    }

    public static String getContent(URL url, Settings settings, String encoding) throws IOException {
        return ProjectInfoReportUtils.getContent(url, null, settings, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(URL url, MavenProject project, Settings settings, String encoding) throws IOException {
        String string;
        String scheme = url.getProtocol();
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = "ISO-8859-1";
        }
        if ("file".equals(scheme)) {
            String string2;
            InputStream in = null;
            try {
                URLConnection conn = url.openConnection();
                in = conn.getInputStream();
                string2 = IOUtil.toString((InputStream)in, (String)encoding);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close((InputStream)in);
            return string2;
        }
        Proxy proxy = settings.getActiveProxy();
        if (proxy != null) {
            scheme = "http".equals(scheme) || "https".equals(scheme) || "ftp".equals(scheme) ? scheme + "." : "";
            String host = proxy.getHost();
            if (!StringUtils.isEmpty((String)host)) {
                String userName;
                Properties p = System.getProperties();
                p.setProperty(scheme + "proxySet", "true");
                p.setProperty(scheme + "proxyHost", host);
                p.setProperty(scheme + "proxyPort", String.valueOf(proxy.getPort()));
                if (!StringUtils.isEmpty((String)proxy.getNonProxyHosts())) {
                    p.setProperty(scheme + "nonProxyHosts", proxy.getNonProxyHosts());
                }
                if (!StringUtils.isEmpty((String)(userName = proxy.getUsername()))) {
                    final String pwd = StringUtils.isEmpty((String)proxy.getPassword()) ? "" : proxy.getPassword();
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(userName, pwd.toCharArray());
                        }
                    });
                }
            }
        }
        InputStream in = null;
        try {
            URLConnection conn = ProjectInfoReportUtils.getURLConnection(url, project, settings);
            in = conn.getInputStream();
            string = IOUtil.toString((InputStream)in, (String)encoding);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        return string;
    }

    public static String getArtifactUrl(ArtifactFactory factory, Artifact artifact, MavenProjectBuilder mavenProjectBuilder, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        Artifact copyArtifact = ArtifactUtils.copyArtifact((Artifact)artifact);
        if (!"pom".equals(copyArtifact.getType())) {
            copyArtifact = factory.createProjectArtifact(copyArtifact.getGroupId(), copyArtifact.getArtifactId(), copyArtifact.getVersion(), copyArtifact.getScope());
        }
        try {
            MavenProject pluginProject = mavenProjectBuilder.buildFromRepository(copyArtifact, remoteRepositories == null ? Collections.EMPTY_LIST : remoteRepositories, localRepository);
            if (ProjectInfoReportUtils.isArtifactUrlValid(pluginProject.getUrl())) {
                return pluginProject.getUrl();
            }
            return null;
        }
        catch (ProjectBuildingException e) {
            return null;
        }
    }

    public static String getArtifactIdCell(String artifactId, String link) {
        if (StringUtils.isEmpty((String)link)) {
            return artifactId;
        }
        return "{" + artifactId + "," + link + "}";
    }

    public static boolean isArtifactUrlValid(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        return URL_VALIDATOR.isValid(url);
    }

    private static URLConnection getURLConnection(URL url, MavenProject project, Settings settings) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        if (!(settings.getServers() == null || settings.getServers().isEmpty() || project == null || project.getDistributionManagement() == null || project.getDistributionManagement().getRepository() == null && project.getDistributionManagement().getSnapshotRepository() == null || !StringUtils.isNotEmpty((String)project.getDistributionManagement().getRepository().getUrl()) && !StringUtils.isNotEmpty((String)project.getDistributionManagement().getSnapshotRepository().getUrl()))) {
            Server server = null;
            if (url.toString().contains(project.getDistributionManagement().getRepository().getUrl())) {
                server = settings.getServer(project.getDistributionManagement().getRepository().getId());
            }
            if (server == null && url.toString().contains(project.getDistributionManagement().getSnapshotRepository().getUrl())) {
                server = settings.getServer(project.getDistributionManagement().getSnapshotRepository().getId());
            }
            if (server != null && StringUtils.isNotEmpty((String)server.getUsername()) && StringUtils.isNotEmpty((String)server.getPassword())) {
                String up = server.getUsername().trim() + ":" + server.getPassword().trim();
                String upEncoded = new String(Base64.encodeBase64Chunked((byte[])up.getBytes())).trim();
                conn.setRequestProperty("Authorization", "Basic " + upEncoded);
            }
        }
        if (conn instanceof HttpsURLConnection) {
            HostnameVerifier hostnameverifier = new HostnameVerifier(){

                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            ((HttpsURLConnection)conn).setHostnameVerifier(hostnameverifier);
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            }
            catch (NoSuchAlgorithmException e1) {
            }
            catch (KeyManagementException e) {
                // empty catch block
            }
        }
        return conn;
    }

    public static boolean isNumber(String str) {
        if (str.startsWith("+")) {
            str = str.substring(1);
        }
        return NumberUtils.isNumber((String)str);
    }

    public static int toInt(String str, int defaultValue) {
        if (str.startsWith("+")) {
            str = str.substring(1);
        }
        return NumberUtils.toInt((String)str, (int)defaultValue);
    }
}

