/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Predicate;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.lang.Language;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.pmd.ExcludeDuplicationsFromFile;
import org.apache.maven.plugins.pmd.exec.CpdRequest;
import org.apache.maven.plugins.pmd.exec.CpdResult;
import org.apache.maven.plugins.pmd.exec.Executor;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpdExecutor
extends Executor {
    private static final Logger LOG = LoggerFactory.getLogger(CpdExecutor.class);
    private final CpdRequest request;
    private final ExcludeDuplicationsFromFile excludeDuplicationsFromFile = new ExcludeDuplicationsFromFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CpdResult execute(CpdRequest request) throws MavenReportException {
        if (request.getJavaExecutable() != null) {
            return CpdExecutor.fork(request);
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CpdExecutor.class.getClassLoader());
            CpdExecutor cpdExecutor = new CpdExecutor(request);
            CpdResult cpdResult = cpdExecutor.run();
            return cpdResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private static CpdResult fork(CpdRequest request) throws MavenReportException {
        File basePmdDir = new File(request.getTargetDirectory(), "pmd");
        basePmdDir.mkdirs();
        File cpdRequestFile = new File(basePmdDir, "cpdrequest.bin");
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cpdRequestFile));){
            out.writeObject(request);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        String classpath = CpdExecutor.buildClasspath();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.environment().put("CLASSPATH", classpath);
        pb.command().add(request.getJavaExecutable());
        pb.command().add(CpdExecutor.class.getName());
        pb.command().add(cpdRequestFile.getAbsolutePath());
        LOG.debug("Executing: CLASSPATH={}, command={}", (Object)classpath, pb.command());
        try {
            Process p = pb.start();
            Executor.ProcessStreamHandler.start(p.getInputStream(), System.out);
            Executor.ProcessStreamHandler.start(p.getErrorStream(), System.err);
            int exit = p.waitFor();
            LOG.debug("CpdExecutor exit code: {}", (Object)exit);
            if (exit != 0) {
                throw new MavenReportException("CpdExecutor exited with exit code " + exit);
            }
            return new CpdResult(new File(request.getTargetDirectory(), "cpd.xml"), request.getOutputEncoding());
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
    }

    public static void main(String[] args) {
        File requestFile = new File(args[0]);
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(requestFile));){
            CpdRequest request = (CpdRequest)in.readObject();
            CpdExecutor cpdExecutor = new CpdExecutor(request);
            cpdExecutor.setupLogLevel(request.getLogLevel());
            cpdExecutor.run();
            System.exit(0);
        }
        catch (IOException | ClassNotFoundException | MavenReportException e) {
            LOG.error(e.getMessage(), e);
        }
        System.exit(1);
    }

    public CpdExecutor(CpdRequest request) {
        this.request = Objects.requireNonNull(request);
    }

    private CpdResult run() throws MavenReportException {
        try {
            this.excludeDuplicationsFromFile.loadExcludeFromFailuresData(this.request.getExcludeFromFailureFile());
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Error loading exclusions", (Exception)((Object)e));
        }
        CPDConfiguration cpdConfiguration = new CPDConfiguration();
        cpdConfiguration.setMinimumTileSize(this.request.getMinimumTokens());
        cpdConfiguration.setIgnoreAnnotations(this.request.isIgnoreAnnotations());
        cpdConfiguration.setIgnoreLiterals(this.request.isIgnoreLiterals());
        cpdConfiguration.setIgnoreIdentifiers(this.request.isIgnoreIdentifiers());
        String languageId = this.request.getLanguage();
        if ("javascript".equals(languageId)) {
            languageId = "ecmascript";
        } else if (languageId == null) {
            languageId = "java";
        }
        Language cpdLanguage = cpdConfiguration.getLanguageRegistry().getLanguageById(languageId);
        cpdConfiguration.setOnlyRecognizeLanguage(cpdLanguage);
        cpdConfiguration.setSourceEncoding(Charset.forName(this.request.getSourceEncoding()));
        this.request.getFiles().forEach(f -> cpdConfiguration.addInputPath(f.toPath()));
        LOG.debug("Executing CPD...");
        try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)cpdConfiguration);){
            cpd.performAnalysis(report -> {
                try {
                    this.writeXmlReport((CPDReport)report);
                    String format = this.request.getFormat();
                    if (!"html".equals(format) && !"xml".equals(format)) {
                        this.writeFormattedReport((CPDReport)report);
                    }
                }
                catch (MavenReportException e) {
                    LOG.error("Error while writing CPD report", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOG.error("Error while executing CPD", (Throwable)e);
        }
        LOG.debug("CPD finished.");
        return new CpdResult(new File(this.request.getTargetDirectory(), "cpd.xml"), this.request.getOutputEncoding());
    }

    private void writeXmlReport(CPDReport cpd) throws MavenReportException {
        File targetFile = this.writeReport(cpd, (CPDReportRenderer)new XMLRenderer(this.request.getOutputEncoding()), "xml");
        if (this.request.isIncludeXmlInSite()) {
            File siteDir = new File(this.request.getReportOutputDirectory());
            siteDir.mkdirs();
            try {
                FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "cpd.xml"));
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
        }
    }

    private File writeReport(CPDReport cpd, CPDReportRenderer r, String extension) throws MavenReportException {
        if (r == null) {
            return null;
        }
        File targetDir = new File(this.request.getTargetDirectory());
        targetDir.mkdirs();
        File targetFile = new File(targetDir, "cpd." + extension);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.request.getOutputEncoding());){
            r.render(cpd.filterMatches(this.filterMatches()), (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
        return targetFile;
    }

    private void writeFormattedReport(CPDReport cpd) throws MavenReportException {
        CPDReportRenderer r = CpdExecutor.createRenderer(this.request.getFormat(), this.request.getOutputEncoding());
        this.writeReport(cpd, r, this.request.getFormat());
    }

    public static CPDReportRenderer createRenderer(String format, String outputEncoding) throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(format)) {
            renderer = new XMLRenderer(outputEncoding);
        } else if ("csv".equals(format)) {
            renderer = new CSVRenderer();
        } else if ("txt".equals(format)) {
            renderer = new SimpleRenderer();
        } else if (!"".equals(format) && !"none".equals(format)) {
            try {
                renderer = (CPDReportRenderer)Class.forName(format).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find CPD custom format " + format + ": " + e.getClass().getName(), e);
            }
        }
        return renderer;
    }

    private Predicate<Match> filterMatches() {
        return match -> {
            LOG.debug("Filtering duplications. Using " + this.excludeDuplicationsFromFile.countExclusions() + " configured exclusions.");
            if (this.excludeDuplicationsFromFile.isExcludedFromFailure((Match)match)) {
                LOG.debug("Excluded " + match + " duplications.");
                return false;
            }
            return true;
        };
    }
}

