/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import net.sourceforge.pmd.RulePriority;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.PmdFileInfo;
import org.apache.maven.plugins.pmd.model.ProcessingError;
import org.apache.maven.plugins.pmd.model.SuppressedViolation;
import org.apache.maven.plugins.pmd.model.Violation;
import org.codehaus.plexus.util.StringUtils;

public class PmdReportGenerator {
    private Log log;
    private Sink sink;
    private String currentFilename;
    private ResourceBundle bundle;
    private Set<Violation> violations = new HashSet<Violation>();
    private List<SuppressedViolation> suppressedViolations = new ArrayList<SuppressedViolation>();
    private List<ProcessingError> processingErrors = new ArrayList<ProcessingError>();
    private boolean aggregate;
    private boolean renderRuleViolationPriority;
    private boolean renderViolationsByPriority;
    private Map<File, PmdFileInfo> files;

    public PmdReportGenerator(Log log, Sink sink, ResourceBundle bundle, boolean aggregate) {
        this.log = log;
        this.sink = sink;
        this.bundle = bundle;
        this.aggregate = aggregate;
    }

    private String getTitle() {
        return this.bundle.getString("report.pmd.title");
    }

    public void setViolations(Collection<Violation> violations) {
        this.violations = new HashSet<Violation>(violations);
    }

    public List<Violation> getViolations() {
        return new ArrayList<Violation>(this.violations);
    }

    public void setSuppressedViolations(Collection<SuppressedViolation> suppressedViolations) {
        this.suppressedViolations = new ArrayList<SuppressedViolation>(suppressedViolations);
    }

    public void setProcessingErrors(Collection<ProcessingError> errors) {
        this.processingErrors = new ArrayList<ProcessingError>(errors);
    }

    public List<ProcessingError> getProcessingErrors() {
        return this.processingErrors;
    }

    private String shortenFilename(String filename, PmdFileInfo fileInfo) {
        String result = filename;
        if (fileInfo != null && fileInfo.getSourceDirectory() != null) {
            result = StringUtils.substring((String)result, (int)(fileInfo.getSourceDirectory().getAbsolutePath().length() + 1));
        }
        return StringUtils.replace((String)result, (String)"\\", (String)"/");
    }

    private String makeFileSectionName(String filename, PmdFileInfo fileInfo) {
        if (this.aggregate && fileInfo != null && fileInfo.getProject() != null) {
            return fileInfo.getProject().getName() + " - " + filename;
        }
        return filename;
    }

    private PmdFileInfo determineFileInfo(String filename) throws IOException {
        File canonicalFilename = new File(filename).getCanonicalFile();
        PmdFileInfo fileInfo = this.files.get(canonicalFilename);
        if (fileInfo == null) {
            this.log.warn((CharSequence)("Couldn't determine PmdFileInfo for file " + filename + " (canonical: " + canonicalFilename + "). XRef links won't be available."));
        }
        return fileInfo;
    }

    private void startFileSection(int level, String currentFilename, PmdFileInfo fileInfo) {
        this.sink.section(level, null);
        this.sink.sectionTitle(level, null);
        this.currentFilename = this.shortenFilename(currentFilename, fileInfo);
        this.sink.text(this.makeFileSectionName(this.currentFilename, fileInfo));
        this.sink.sectionTitle_(level);
        this.sink.table();
        this.sink.tableRows(null, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.column.rule"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.column.violation"));
        this.sink.tableHeaderCell_();
        if (this.renderRuleViolationPriority) {
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.pmd.column.priority"));
            this.sink.tableHeaderCell_();
        }
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.column.line"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    private void endFileSection(int level) {
        this.sink.tableRows_();
        this.sink.table_();
        this.sink.section_(level);
    }

    private void addRuleName(Violation ruleViolation) {
        boolean hasUrl = StringUtils.isNotBlank((String)ruleViolation.getExternalInfoUrl());
        if (hasUrl) {
            this.sink.link(ruleViolation.getExternalInfoUrl());
        }
        this.sink.text(ruleViolation.getRule());
        if (hasUrl) {
            this.sink.link_();
        }
    }

    private void processSingleRuleViolation(Violation ruleViolation, PmdFileInfo fileInfo) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.addRuleName(ruleViolation);
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(ruleViolation.getText());
        this.sink.tableCell_();
        if (this.renderRuleViolationPriority) {
            this.sink.tableCell();
            this.sink.text(String.valueOf(RulePriority.valueOf((int)ruleViolation.getPriority()).getPriority()));
            this.sink.tableCell_();
        }
        this.sink.tableCell();
        int beginLine = ruleViolation.getBeginline();
        this.outputLineLink(beginLine, fileInfo);
        int endLine = ruleViolation.getEndline();
        if (endLine != beginLine) {
            this.sink.text("&#x2013;");
            this.outputLineLink(endLine, fileInfo);
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void renderViolations() throws IOException {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.pmd.files"));
        this.sink.sectionTitle1_();
        ArrayList<Violation> violations2 = new ArrayList<Violation>(this.violations);
        this.renderViolationsTable(2, violations2);
        this.sink.section1_();
    }

    private void renderViolationsByPriority() throws IOException {
        if (!this.renderViolationsByPriority) {
            return;
        }
        boolean oldPriorityColumn = this.renderRuleViolationPriority;
        this.renderRuleViolationPriority = false;
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.pmd.violationsByPriority"));
        this.sink.sectionTitle1_();
        HashMap<RulePriority, ArrayList<Violation>> violationsByPriority = new HashMap<RulePriority, ArrayList<Violation>>();
        for (Violation violation : this.violations) {
            RulePriority priority = RulePriority.valueOf((int)violation.getPriority());
            ArrayList<Violation> violationSegment = (ArrayList<Violation>)violationsByPriority.get(priority);
            if (violationSegment == null) {
                violationSegment = new ArrayList<Violation>();
                violationsByPriority.put(priority, violationSegment);
            }
            violationSegment.add(violation);
        }
        for (RulePriority priority : RulePriority.values()) {
            List violationsWithPriority = (List)violationsByPriority.get(priority);
            if (violationsWithPriority == null || violationsWithPriority.isEmpty()) continue;
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.text(this.bundle.getString("report.pmd.priority") + " " + priority.getPriority());
            this.sink.sectionTitle2_();
            this.renderViolationsTable(3, violationsWithPriority);
            this.sink.section2_();
        }
        if (this.violations.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.bundle.getString("report.pmd.noProblems"));
            this.sink.paragraph_();
        }
        this.sink.section1_();
        this.renderRuleViolationPriority = oldPriorityColumn;
    }

    private void renderViolationsTable(int level, List<Violation> violationSegment) throws IOException {
        Collections.sort(violationSegment, new Comparator<Violation>(){

            @Override
            public int compare(Violation o1, Violation o2) {
                int filenames = o1.getFileName().compareTo(o2.getFileName());
                if (filenames == 0) {
                    return o1.getBeginline() - o2.getBeginline();
                }
                return filenames;
            }
        });
        boolean fileSectionStarted = false;
        String previousFilename = null;
        for (Violation ruleViolation : violationSegment) {
            String currentFn = ruleViolation.getFileName();
            PmdFileInfo fileInfo = this.determineFileInfo(currentFn);
            if (!currentFn.equalsIgnoreCase(previousFilename) && fileSectionStarted) {
                this.endFileSection(level);
                fileSectionStarted = false;
            }
            if (!fileSectionStarted) {
                this.startFileSection(level, currentFn, fileInfo);
                fileSectionStarted = true;
            }
            this.processSingleRuleViolation(ruleViolation, fileInfo);
            previousFilename = currentFn;
        }
        if (fileSectionStarted) {
            this.endFileSection(level);
        }
    }

    private void outputLineLink(int line, PmdFileInfo fileInfo) {
        String xrefLocation = null;
        if (fileInfo != null) {
            xrefLocation = fileInfo.getXrefLocation();
        }
        if (xrefLocation != null) {
            this.sink.link(xrefLocation + "/" + this.currentFilename.replaceAll("\\.java$", ".html") + "#L" + line);
        }
        this.sink.text(String.valueOf(line));
        if (xrefLocation != null) {
            this.sink.link_();
        }
    }

    private void renderSuppressedViolations() throws IOException {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.pmd.suppressedViolations.title"));
        this.sink.sectionTitle1_();
        Collections.sort(this.suppressedViolations, new Comparator<SuppressedViolation>(){

            @Override
            public int compare(SuppressedViolation o1, SuppressedViolation o2) {
                return o1.getFilename().compareTo(o2.getFilename());
            }
        });
        this.sink.table();
        this.sink.tableRows(null, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.suppressedViolations.column.filename"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.suppressedViolations.column.ruleMessage"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.suppressedViolations.column.suppressionType"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.suppressedViolations.column.userMessage"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        for (SuppressedViolation suppressedViolation : this.suppressedViolations) {
            String filename = suppressedViolation.getFilename();
            PmdFileInfo fileInfo = this.determineFileInfo(filename);
            filename = this.shortenFilename(filename, fileInfo);
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(filename);
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(suppressedViolation.getRuleMessage());
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(suppressedViolation.getSuppressionType());
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(suppressedViolation.getUserMessage());
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRows_();
        this.sink.table_();
        this.sink.section1_();
    }

    private void processProcessingErrors() throws IOException {
        Collections.sort(this.processingErrors, new Comparator<ProcessingError>(){

            @Override
            public int compare(ProcessingError e1, ProcessingError e2) {
                return e1.getFilename().compareTo(e2.getFilename());
            }
        });
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.pmd.processingErrors.title"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRows(null, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.processingErrors.column.filename"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.processingErrors.column.problem"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        for (ProcessingError error : this.processingErrors) {
            this.processSingleProcessingError(error);
        }
        this.sink.tableRows_();
        this.sink.table_();
        this.sink.section1_();
    }

    private void processSingleProcessingError(ProcessingError error) throws IOException {
        String filename = error.getFilename();
        PmdFileInfo fileInfo = this.determineFileInfo(filename);
        filename = this.makeFileSectionName(this.shortenFilename(filename, fileInfo), fileInfo);
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(filename);
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(error.getMsg());
        this.sink.verbatim(null);
        this.sink.rawText(error.getDetail());
        this.sink.verbatim_();
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    public void beginDocument() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.pmd.pmdlink") + " ");
        this.sink.link("https://pmd.github.io");
        this.sink.text("PMD");
        this.sink.link_();
        this.sink.text(" " + AbstractPmdReport.getPmdVersion() + ".");
        this.sink.paragraph_();
        this.sink.section1_();
    }

    public void render() throws IOException {
        if (!this.violations.isEmpty()) {
            this.renderViolationsByPriority();
            this.renderViolations();
        } else {
            this.sink.paragraph();
            this.sink.text(this.bundle.getString("report.pmd.noProblems"));
            this.sink.paragraph_();
        }
        if (!this.suppressedViolations.isEmpty()) {
            this.renderSuppressedViolations();
        }
        if (!this.processingErrors.isEmpty()) {
            this.processProcessingErrors();
        }
    }

    public void endDocument() throws IOException {
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    public void setFiles(Map<File, PmdFileInfo> files) {
        this.files = files;
    }

    public void setRenderRuleViolationPriority(boolean renderRuleViolationPriority) {
        this.renderRuleViolationPriority = renderRuleViolationPriority;
    }

    public void setRenderViolationsByPriority(boolean renderViolationsByPriority) {
        this.renderViolationsByPriority = renderViolationsByPriority;
    }
}

