/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.EcmascriptLanguage;
import net.sourceforge.pmd.cpd.JSPLanguage;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.CpdReportGenerator;
import org.apache.maven.plugins.pmd.ExcludeDuplicationsFromFile;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;

@Mojo(name="cpd", threadSafe=true)
public class CpdReport
extends AbstractPmdReport {
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumTokens", defaultValue="100")
    private int minimumTokens;
    @Parameter(property="cpd.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cpd.ignoreLiterals", defaultValue="false")
    private boolean ignoreLiterals;
    @Parameter(property="cpd.ignoreIdentifiers", defaultValue="false")
    private boolean ignoreIdentifiers;
    @Parameter(property="cpd.ignoreAnnotations", defaultValue="false")
    private boolean ignoreAnnotations;
    private CPD cpd;
    private final ExcludeDuplicationsFromFile excludeDuplicationsFromFile = new ExcludeDuplicationsFromFile();

    public String getName(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.name");
    }

    public String getDescription(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.description");
    }

    public void executeReport(Locale locale) throws MavenReportException {
        try {
            this.execute(locale);
        }
        finally {
            if (this.getSink() != null) {
                this.getSink().close();
            }
        }
    }

    private void execute(Locale locale) throws MavenReportException {
        if (!this.skip && this.canGenerateReport()) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.generateMavenSiteReport(locale);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    @Override
    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        boolean result = super.canGenerateReport();
        if (result) {
            try {
                this.executeCpdWithClassloader();
                if (this.skipEmptyReport && (result = this.cpd.getMatches().hasNext())) {
                    this.getLog().debug((CharSequence)"Skipping report since skipEmptyReport is true and there are no CPD issues.");
                }
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void executeCpdWithClassloader() throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.executeCpd();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private void executeCpd() throws MavenReportException {
        if (this.cpd != null) {
            this.getLog().debug((CharSequence)"CPD has already been run - skipping redundant execution.");
            return;
        }
        this.setupPmdLogging();
        Properties p = new Properties();
        if (this.ignoreLiterals) {
            p.setProperty("ignore_literals", "true");
        }
        if (this.ignoreIdentifiers) {
            p.setProperty("ignore_identifiers", "true");
        }
        if (this.ignoreAnnotations) {
            p.setProperty("ignore_annotations", "true");
        }
        try {
            if (this.filesToProcess == null) {
                this.filesToProcess = this.getFilesToProcess();
            }
            try {
                this.excludeDuplicationsFromFile.loadExcludeFromFailuresData(this.excludeFromFailureFile);
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException("Error loading exclusions", (Exception)((Object)e));
            }
            String encoding = this.determineEncoding(!this.filesToProcess.isEmpty());
            Object cpdLanguage = "java".equals(this.language) || null == this.language ? new JavaLanguage(p) : ("javascript".equals(this.language) ? new EcmascriptLanguage() : ("jsp".equals(this.language) ? new JSPLanguage() : LanguageFactory.createLanguage((String)this.language, (Properties)p)));
            CPDConfiguration cpdConfiguration = new CPDConfiguration();
            cpdConfiguration.setMinimumTileSize(this.minimumTokens);
            cpdConfiguration.setLanguage((Language)cpdLanguage);
            cpdConfiguration.setSourceEncoding(encoding);
            this.cpd = new CPD(cpdConfiguration);
            for (File file : this.filesToProcess.keySet()) {
                this.cpd.add(file);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MavenReportException("Encoding '" + this.getSourceEncoding() + "' is not supported.", (Exception)e);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        this.getLog().debug((CharSequence)"Executing CPD...");
        this.cpd.go();
        this.getLog().debug((CharSequence)"CPD finished.");
        this.writeXmlReport(this.cpd);
        if (!this.isHtml() && !this.isXml()) {
            this.writeFormattedReport(this.cpd);
        }
    }

    private Iterator<Match> filterMatches(Iterator<Match> matches) {
        this.getLog().debug((CharSequence)("Filtering duplications. Using " + this.excludeDuplicationsFromFile.countExclusions() + " configured exclusions."));
        ArrayList<Match> filteredMatches = new ArrayList<Match>();
        int excludedDuplications = 0;
        while (matches.hasNext()) {
            Match match = matches.next();
            if (this.excludeDuplicationsFromFile.isExcludedFromFailure(match)) {
                ++excludedDuplications;
                continue;
            }
            filteredMatches.add(match);
        }
        this.getLog().debug((CharSequence)("Excluded " + excludedDuplications + " duplications."));
        return filteredMatches.iterator();
    }

    private void generateMavenSiteReport(Locale locale) {
        CpdReportGenerator gen = new CpdReportGenerator(this.getSink(), this.filesToProcess, CpdReport.getBundle(locale), this.aggregate);
        Iterator matches = this.cpd.getMatches();
        gen.generate(this.filterMatches(matches));
    }

    private String determineEncoding(boolean showWarn) throws UnsupportedEncodingException {
        String encoding = WriterFactory.FILE_ENCODING;
        if (StringUtils.isNotEmpty((String)this.getSourceEncoding())) {
            encoding = this.getSourceEncoding();
            WriterFactory.newWriter((OutputStream)new ByteArrayOutputStream(), (String)encoding);
        } else if (showWarn) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + WriterFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            encoding = WriterFactory.FILE_ENCODING;
        }
        return encoding;
    }

    private void writeFormattedReport(CPD cpd) throws MavenReportException {
        CPDRenderer r = this.createRenderer();
        this.writeReport(cpd, r, this.format);
    }

    void writeXmlReport(CPD cpd) throws MavenReportException {
        File targetFile = this.writeReport(cpd, (CPDRenderer)new XMLRenderer(this.getOutputEncoding()), "xml");
        if (this.includeXmlInSite) {
            File siteDir = this.getReportOutputDirectory();
            siteDir.mkdirs();
            try {
                FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "cpd.xml"));
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
        }
    }

    private File writeReport(CPD cpd, CPDRenderer r, String extension) throws MavenReportException {
        if (r == null) {
            return null;
        }
        File targetFile = new File(this.targetDirectory, "cpd." + extension);
        this.targetDirectory.mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.getOutputEncoding());){
            r.render(this.filterMatches(cpd.getMatches()), (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
        return targetFile;
    }

    public String getOutputName() {
        return "cpd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cpd-report", locale, CpdReport.class.getClassLoader());
    }

    public CPDRenderer createRenderer() throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer(this.getOutputEncoding());
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (CPDRenderer)Class.forName(this.format).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find CPD custom format " + this.format + ": " + e.getClass().getName(), e);
            }
        }
        return renderer;
    }
}

